/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

public class MultiUpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = CONFIG.getBoolean("client.undo.onlyCareUpdateColumns", true);

    public MultiUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        if (this.sqlRecognizers.size() == 1) {
            UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
            return executor.beforeImage();
        }
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        HashSet<String> updateColumnsSet = new HashSet<String>();
        StringBuilder whereCondition = new StringBuilder();
        boolean noWhereCondition = false;
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)recognizer;
            if (StringUtils.isNotBlank(sqlUpdateRecognizer.getLimitCondition())) {
                throw new NotSupportYetException("Multi update SQL with limit condition is not support yet !");
            }
            if (StringUtils.isNotBlank(sqlUpdateRecognizer.getOrderByCondition())) {
                throw new NotSupportYetException("Multi update SQL with orderBy condition is not support yet !");
            }
            List<String> updateColumns = sqlUpdateRecognizer.getUpdateColumnsIsSimplified();
            updateColumnsSet.addAll(updateColumns);
            if (noWhereCondition) continue;
            String whereConditionStr = this.buildWhereCondition(sqlUpdateRecognizer, paramAppenderList);
            if (StringUtils.isBlank(whereConditionStr)) {
                noWhereCondition = true;
                continue;
            }
            if (whereCondition.length() > 0) {
                whereCondition.append(" OR ");
            }
            whereCondition.append(whereConditionStr);
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        if (noWhereCondition) {
            paramAppenderList.clear();
        } else {
            suffix.append(" WHERE ").append((CharSequence)whereCondition);
        }
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLAppender = new StringJoiner(", ", prefix, suffix.toString());
        if (ONLY_CARE_UPDATE_COLUMNS) {
            if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
                selectSQLAppender.add(this.getColumnNamesInSQL(tmeta.getEscapePkNameList(this.getDbType())));
            }
            for (String updateCol : updateColumnsSet) {
                selectSQLAppender.add(updateCol);
            }
        } else {
            for (String columnName : tmeta.getAllColumns().keySet()) {
                selectSQLAppender.add(ColumnUtils.addEscape(columnName, this.getDbType()));
            }
        }
        return this.buildTableRecords(tmeta, selectSQLAppender.toString(), paramAppenderList);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) throws SQLException {
        HashSet<String> updateColumnsSet = new HashSet<String>();
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
            updateColumnsSet.addAll(sqlUpdateRecognizer.getUpdateColumnsIsSimplified());
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        String suffix = " FROM " + this.getFromTableInSQL() + " WHERE " + SqlGenerateUtils.buildWhereConditionByPKs(tableMeta.getPrimaryKeyOnlyName(), beforeImage.pkRows().size(), this.getDbType());
        StringJoiner selectSQLJoiner = new StringJoiner(", ", prefix.toString(), suffix);
        if (ONLY_CARE_UPDATE_COLUMNS) {
            if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
                selectSQLJoiner.add(this.getColumnNamesInSQL(tableMeta.getEscapePkNameList(this.getDbType())));
            }
            for (String updateCol : updateColumnsSet) {
                selectSQLJoiner.add(updateCol);
            }
        } else {
            for (String columnName : tableMeta.getAllColumns().keySet()) {
                selectSQLJoiner.add(ColumnUtils.addEscape(columnName, this.getDbType()));
            }
        }
        return selectSQLJoiner.toString();
    }
}

