/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.convert.datasource;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.transaction.xa.convert.datasource.XAProperties;
import io.shardingsphere.transaction.xa.convert.datasource.dialect.H2XAProperties;
import io.shardingsphere.transaction.xa.convert.datasource.dialect.MySQLXAProperties;
import io.shardingsphere.transaction.xa.convert.datasource.dialect.OracleXAProperties;
import io.shardingsphere.transaction.xa.convert.datasource.dialect.PostgreSQLXAProperties;
import io.shardingsphere.transaction.xa.convert.datasource.dialect.SQLServerXAProperties;

public final class XAPropertiesFactory {
    public static XAProperties createXAProperties(DatabaseType databaseType) {
        switch (databaseType) {
            case H2: {
                return new H2XAProperties();
            }
            case MySQL: {
                return new MySQLXAProperties();
            }
            case PostgreSQL: {
                return new PostgreSQLXAProperties();
            }
            case Oracle: {
                return new OracleXAProperties();
            }
            case SQLServer: {
                return new SQLServerXAProperties();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type: `%s`", databaseType));
    }

    private XAPropertiesFactory() {
    }
}

