/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.transaction.xa.manager;

import com.atomikos.icatch.jta.UserTransactionManager;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.transaction.core.context.XATransactionContext;
import io.shardingsphere.transaction.spi.xa.XATransactionManager;
import io.shardingsphere.transaction.xa.manager.AtomikosDataSourceBeanWrapper;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public final class AtomikosTransactionManager
implements XATransactionManager {
    private final UserTransactionManager underlyingTransactionManager = new UserTransactionManager();

    public AtomikosTransactionManager() {
        this.init();
    }

    private void init() {
        try {
            this.underlyingTransactionManager.init();
        }
        catch (SystemException ex) {
            throw new ShardingException((Exception)((Object)ex));
        }
    }

    public void destroy() {
        this.underlyingTransactionManager.setForceShutdown(true);
        this.underlyingTransactionManager.close();
    }

    public void begin(XATransactionContext transactionContext) throws ShardingException {
        try {
            this.underlyingTransactionManager.begin();
        }
        catch (NotSupportedException | SystemException ex) {
            throw new ShardingException((Exception)ex);
        }
    }

    public void commit(XATransactionContext transactionContext) throws ShardingException {
        try {
            this.underlyingTransactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException ex) {
            throw new ShardingException((Exception)ex);
        }
    }

    public void rollback(XATransactionContext transactionContext) throws ShardingException {
        try {
            if (6 != this.getStatus()) {
                this.underlyingTransactionManager.rollback();
            }
        }
        catch (SystemException ex) {
            throw new ShardingException((Exception)((Object)ex));
        }
    }

    public int getStatus() throws ShardingException {
        try {
            return this.underlyingTransactionManager.getStatus();
        }
        catch (SystemException ex) {
            throw new ShardingException((Exception)((Object)ex));
        }
    }

    public DataSource wrapDataSource(DatabaseType databaseType, XADataSource xaDataSource, String dataSourceName, DataSourceParameter dataSourceParameter) {
        try {
            return new AtomikosDataSourceBeanWrapper().wrap(databaseType, xaDataSource, dataSourceName, dataSourceParameter);
        }
        catch (Exception ex) {
            throw new ShardingException("Failed to wrap XADataSource to transactional datasource pool", ex);
        }
    }

    public TransactionManager getUnderlyingTransactionManager() {
        return this.underlyingTransactionManager;
    }
}

