/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.elasticsearch.http;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Response;
import okio.BufferedSource;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.DependencyLinker;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin.storage.elasticsearch.http.LegacyJsonAdapters;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.IndexNameFormatter;
import zipkin2.elasticsearch.internal.JsonReaders;
import zipkin2.elasticsearch.internal.client.Aggregation;
import zipkin2.elasticsearch.internal.client.HttpCall;
import zipkin2.elasticsearch.internal.client.SearchCallFactory;
import zipkin2.elasticsearch.internal.client.SearchRequest;
import zipkin2.elasticsearch.internal.client.SearchResultConverter;

final class LegacyElasticsearchHttpSpanStore
implements AsyncSpanStore {
    static final String SPAN = "span";
    static final String DEPENDENCY_LINK = "dependencylink";
    static final String SERVICE_SPAN = "servicespan";
    static final long EARLIEST_MS = 1456790400000L;
    static final HttpCall.BodyConverter<List<String>> KEYS = new HttpCall.BodyConverter<List<String>>(){

        public List<String> convert(BufferedSource b) throws IOException {
            return JsonReaders.collectValuesNamed((JsonReader)JsonReader.of((BufferedSource)b), (String)"key");
        }
    };
    static final HttpCall.BodyConverter<List<Span>> SPANS = SearchResultConverter.create(LegacyJsonAdapters.SPAN_ADAPTER);
    static final HttpCall.BodyConverter<List<Span>> NULLABLE_SPANS = SearchResultConverter.create(LegacyJsonAdapters.SPAN_ADAPTER).defaultToNull();
    static final HttpCall.BodyConverter<List<DependencyLink>> DEPENDENCY_LINKS = new SearchResultConverter<DependencyLink>(LegacyJsonAdapters.LINK_ADAPTER){

        public List<DependencyLink> convert(BufferedSource content) throws IOException {
            List result = super.convert(content);
            return result.isEmpty() ? result : DependencyLinker.merge((Iterable)result);
        }
    };
    final SearchCallFactory search;
    final String[] allIndices;
    final IndexNameFormatter indexNameFormatter;
    final boolean strictTraceId;
    final int namesLookback;

    LegacyElasticsearchHttpSpanStore(ElasticsearchStorage es) {
        this.search = new SearchCallFactory(es.http());
        this.allIndices = new String[]{es.indexNameFormatter().formatType(null)};
        this.indexNameFormatter = es.indexNameFormatter();
        this.strictTraceId = es.strictTraceId();
        this.namesLookback = es.namesLookback();
    }

    public void getTraces(final QueryRequest request, final Callback<List<List<Span>>> callback) {
        long endMillis = request.endTs;
        long beginMillis = Math.max(endMillis - request.lookback, 1456790400000L);
        SearchRequest.Filters filters = new SearchRequest.Filters();
        filters.addRange("timestamp_millis", beginMillis, Long.valueOf(endMillis));
        if (request.serviceName != null) {
            filters.addNestedTerms(Arrays.asList("annotations.endpoint.serviceName", "binaryAnnotations.endpoint.serviceName"), request.serviceName);
        }
        if (request.spanName != null) {
            filters.addTerm("name", request.spanName);
        }
        for (String string : request.annotations) {
            LinkedHashMap<String, String> annotationValues = new LinkedHashMap<String, String>();
            annotationValues.put("annotations.value", string);
            LinkedHashMap<String, String> binaryAnnotationKeys = new LinkedHashMap<String, String>();
            binaryAnnotationKeys.put("binaryAnnotations.key", string);
            if (request.serviceName != null) {
                annotationValues.put("annotations.endpoint.serviceName", request.serviceName);
                binaryAnnotationKeys.put("binaryAnnotations.endpoint.serviceName", request.serviceName);
            }
            filters.addNestedTerms(new Map[]{annotationValues, binaryAnnotationKeys});
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            LinkedHashMap<String, String> nestedTerms = new LinkedHashMap<String, String>();
            nestedTerms.put("binaryAnnotations.key", (String)entry.getKey());
            nestedTerms.put("binaryAnnotations.value", (String)entry.getValue());
            if (request.serviceName != null) {
                nestedTerms.put("binaryAnnotations.endpoint.serviceName", request.serviceName);
            }
            filters.addNestedTerms(new Map[]{nestedTerms});
        }
        if (request.minDuration != null) {
            filters.addRange("duration", request.minDuration.longValue(), request.maxDuration);
        }
        Aggregation traceIdTimestamp = Aggregation.terms((String)"traceId", (int)request.limit).addSubAggregation(Aggregation.min((String)"timestamp_millis")).orderBy("timestamp_millis", "desc");
        final List list = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        if (list.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        SearchRequest esRequest = SearchRequest.create((List)list, (String)SPAN).filters(filters).addAggregation(traceIdTimestamp);
        HttpCall traceIdsCall = this.search.newCall(esRequest, KEYS);
        Callback<List<Span>> successCallback = new Callback<List<Span>>(){

            public void onSuccess(@Nullable List<Span> input) {
                List traces = GroupByTraceId.apply(input, (boolean)LegacyElasticsearchHttpSpanStore.this.strictTraceId, (boolean)true);
                Iterator trace = traces.iterator();
                while (trace.hasNext()) {
                    List next = (List)trace.next();
                    if (((Span)next.get((int)0)).traceIdHigh == 0L || request.test(next)) continue;
                    trace.remove();
                }
                callback.onSuccess((Object)traces);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        };
        LegacyElasticsearchHttpSpanStore.submit(traceIdsCall, new Callback<List<String>>((Callback)successCallback){
            final /* synthetic */ Callback val$successCallback;
            {
                this.val$successCallback = callback2;
            }

            public void onSuccess(@Nullable List<String> traceIds) {
                if (traceIds == null || traceIds.isEmpty()) {
                    callback.onSuccess(Collections.emptyList());
                    return;
                }
                SearchRequest request = SearchRequest.create((List)list, (String)LegacyElasticsearchHttpSpanStore.SPAN).terms("traceId", traceIds);
                LegacyElasticsearchHttpSpanStore.submit(LegacyElasticsearchHttpSpanStore.this.search.newCall(request, SPANS), this.val$successCallback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    public void getTrace(long traceIdHigh, long traceIdLow, final Callback<List<Span>> callback) {
        this.getRawTrace(traceIdHigh, traceIdLow, new Callback<List<Span>>(){

            public void onSuccess(@Nullable List<Span> value) {
                List result = CorrectForClockSkew.apply((List)MergeById.apply(value));
                callback.onSuccess((Object)(result.isEmpty() ? null : result));
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        String traceIdHex = Util.toLowerHex((long)(this.strictTraceId ? traceIdHigh : 0L), (long)traceIdLow);
        SearchRequest request = SearchRequest.create(Arrays.asList(this.allIndices), (String)SPAN).term("traceId", traceIdHex);
        LegacyElasticsearchHttpSpanStore.submit(this.search.newCall(request, NULLABLE_SPANS), callback);
    }

    public void getServiceNames(final Callback<List<String>> callback) {
        final long endMillis = System.currentTimeMillis();
        final long beginMillis = endMillis - (long)this.namesLookback;
        final List indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        if (indices.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        SearchRequest request = SearchRequest.create((List)indices, (String)SERVICE_SPAN).addAggregation(Aggregation.terms((String)"serviceName", (int)Integer.MAX_VALUE));
        LegacyElasticsearchHttpSpanStore.submit(this.search.newCall(request, KEYS), new Callback<List<String>>(){

            public void onSuccess(@Nullable List<String> value) {
                if (!value.isEmpty()) {
                    callback.onSuccess(value);
                }
                SearchRequest.Filters filters = new SearchRequest.Filters();
                filters.addRange("timestamp_millis", beginMillis, Long.valueOf(endMillis));
                SearchRequest request = SearchRequest.create((List)indices, (String)LegacyElasticsearchHttpSpanStore.SPAN).filters(filters).addAggregation(Aggregation.nestedTerms((String)"annotations.endpoint.serviceName")).addAggregation(Aggregation.nestedTerms((String)"binaryAnnotations.endpoint.serviceName"));
                LegacyElasticsearchHttpSpanStore.submit(LegacyElasticsearchHttpSpanStore.this.search.newCall(request, KEYS), callback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getSpanNames(final String serviceName, final Callback<List<String>> callback) {
        if (serviceName == null || "".equals(serviceName)) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        final long endMillis = System.currentTimeMillis();
        final long beginMillis = endMillis - (long)this.namesLookback;
        final List indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endMillis);
        if (indices.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        SearchRequest request = SearchRequest.create((List)indices, (String)SERVICE_SPAN).term("serviceName", serviceName.toLowerCase(Locale.ROOT)).addAggregation(Aggregation.terms((String)"spanName", (int)Integer.MAX_VALUE));
        LegacyElasticsearchHttpSpanStore.submit(this.search.newCall(request, KEYS), new Callback<List<String>>(){

            public void onSuccess(@Nullable List<String> value) {
                if (!value.isEmpty()) {
                    callback.onSuccess(value);
                }
                SearchRequest.Filters filters = new SearchRequest.Filters();
                filters.addRange("timestamp_millis", beginMillis, Long.valueOf(endMillis));
                filters.addNestedTerms(Arrays.asList("annotations.endpoint.serviceName", "binaryAnnotations.endpoint.serviceName"), serviceName.toLowerCase(Locale.ROOT));
                SearchRequest request = SearchRequest.create((List)indices, (String)LegacyElasticsearchHttpSpanStore.SPAN).filters(filters).addAggregation(Aggregation.terms((String)"name", (int)Integer.MAX_VALUE));
                LegacyElasticsearchHttpSpanStore.submit(LegacyElasticsearchHttpSpanStore.this.search.newCall(request, KEYS), callback);
            }

            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        long beginMillis = lookback != null ? Math.max(endTs - lookback, 1456790400000L) : 1456790400000L;
        List indices = this.indexNameFormatter.formatTypeAndRange(null, beginMillis, endTs);
        if (indices.isEmpty()) {
            callback.onSuccess(Collections.emptyList());
            return;
        }
        this.getDependencies(indices, callback);
    }

    void getDependencies(List<String> indices, Callback<List<DependencyLink>> callback) {
        SearchRequest request = SearchRequest.create(indices, (String)DEPENDENCY_LINK);
        LegacyElasticsearchHttpSpanStore.submit(this.search.newCall(request, DEPENDENCY_LINKS), callback);
    }

    static <V> void submit(HttpCall<V> call, Callback<V> delegate) {
        call.call.enqueue(new CallbackAdapter<V>(call.bodyConverter, delegate));
    }

    static class CallbackAdapter<V>
    implements okhttp3.Callback {
        final HttpCall.BodyConverter<V> bodyConverter;
        final Callback<V> delegate;

        CallbackAdapter(HttpCall.BodyConverter<V> bodyConverter, Callback<V> delegate) {
            this.bodyConverter = bodyConverter;
            this.delegate = delegate;
        }

        public void onFailure(Call call, IOException e) {
            this.delegate.onError((Throwable)e);
        }

        public void onResponse(Call call, Response response) {
            try {
                this.delegate.onSuccess(HttpCall.parseResponse((Response)response, this.bodyConverter));
            }
            catch (Throwable e) {
                Util.propagateIfFatal((Throwable)e);
                this.delegate.onError(e);
            }
        }
    }
}

