/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.io.Serializable;
import java.time.Period;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.YearMonthIntervalType;

@Internal
public class YearMonthIntervalPeriodConverter
implements DataStructureConverter<Integer, Period> {
    private static final long serialVersionUID = 1L;
    private final PeriodConstructor periodConstructor;

    private YearMonthIntervalPeriodConverter(PeriodConstructor periodConstructor) {
        this.periodConstructor = periodConstructor;
    }

    @Override
    public Integer toInternal(Period external) {
        return (int)external.toTotalMonths();
    }

    @Override
    public Period toExternal(Integer internal) {
        return this.periodConstructor.construct(internal);
    }

    public static YearMonthIntervalPeriodConverter create(DataType dataType) {
        YearMonthIntervalType intervalType = (YearMonthIntervalType)dataType.getLogicalType();
        return new YearMonthIntervalPeriodConverter(YearMonthIntervalPeriodConverter.createPeriodConstructor(intervalType.getResolution()));
    }

    private static PeriodConstructor createPeriodConstructor(YearMonthIntervalType.YearMonthResolution resolution) {
        switch (resolution) {
            case YEAR: {
                return internal -> Period.ofYears(internal / 12);
            }
            case YEAR_TO_MONTH: {
                return internal -> Period.of(internal / 12, internal % 12, 0);
            }
            case MONTH: {
                return Period::ofMonths;
            }
        }
        throw new IllegalStateException();
    }

    private static interface PeriodConstructor
    extends Serializable {
        public Period construct(Integer var1);
    }
}

