/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.Filter;
import org.apache.hive.service.auth.ldap.FilterFactory;
import org.apache.hive.service.auth.ldap.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(HiveConf conf) {
        Collection groupFilter = conf.getStringCollection(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER.varname);
        if (groupFilter.isEmpty()) {
            return null;
        }
        return new GroupFilter(groupFilter);
    }

    private static final class GroupFilter
    implements Filter {
        private static final Logger LOG = LoggerFactory.getLogger(GroupFilter.class);
        private final Set<String> groupFilter = new HashSet<String>();

        GroupFilter(Collection<String> groupFilter) {
            this.groupFilter.addAll(groupFilter);
        }

        @Override
        public void apply(DirSearch ldap, String user) throws AuthenticationException {
            LOG.info("Authenticating user '{}' using group membership", (Object)user);
            List<String> memberOf = null;
            try {
                String userDn = ldap.findUserDn(user);
                memberOf = ldap.findGroupsForUser(userDn);
                LOG.debug("User {} member of : {}", (Object)userDn, memberOf);
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
            for (String groupDn : memberOf) {
                String shortName = LdapUtils.getShortName(groupDn);
                if (!this.groupFilter.contains(shortName)) continue;
                LOG.info("Authentication succeeded based on group membership");
                return;
            }
            LOG.info("Authentication failed based on user membership");
            throw new AuthenticationException("Authentication failed: User not a member of specified list");
        }
    }
}

