/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class H2DmlPlanKey {
    private final String schemaName;
    private final String sql;
    private final byte flags;

    public H2DmlPlanKey(String schemaName, String sql, boolean loc, SqlFieldsQuery fieldsQry) {
        this.schemaName = schemaName;
        this.sql = sql;
        this.flags = loc || !UpdatePlanBuilder.isSkipReducerOnUpdateQuery(fieldsQry) ? (byte)0 : (byte)(1 + (fieldsQry.isDistributedJoins() ? 2 : 0) + (fieldsQry.isEnforceJoinOrder() ? 4 : 0) + (fieldsQry.isCollocated() ? 8 : 0));
    }

    public int hashCode() {
        return 31 * (31 * (this.schemaName != null ? this.schemaName.hashCode() : 0) + (this.sql != null ? this.sql.hashCode() : 0)) + this.flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        H2DmlPlanKey other = (H2DmlPlanKey)o;
        return F.eq((Object)this.sql, (Object)other.sql) && F.eq((Object)this.schemaName, (Object)other.schemaName) && this.flags == other.flags;
    }

    public String toString() {
        return S.toString(H2DmlPlanKey.class, (Object)this);
    }
}

