/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.query.CacheQueryPartitionInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.CacheQueryObjectValueContext;
import org.apache.ignite.internal.processors.query.GridQueryCacheObjectsIterator;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResultAdapter;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.DmlStatementsProcessor;
import org.apache.ignite.internal.processors.query.h2.H2ConnectionWrapper;
import org.apache.ignite.internal.processors.query.h2.H2DatabaseType;
import org.apache.ignite.internal.processors.query.h2.H2FieldsIterator;
import org.apache.ignite.internal.processors.query.h2.H2KeyValueIterator;
import org.apache.ignite.internal.processors.query.h2.H2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Schema;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableEngine;
import org.apache.ignite.internal.processors.query.h2.H2TwoStepCachedQuery;
import org.apache.ignite.internal.processors.query.h2.H2TwoStepCachedQueryKey;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2InnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2LeafIO;
import org.apache.ignite.internal.processors.query.h2.ddl.DdlStatementsProcessor;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2DefaultTableEngine;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMapQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.GridReduceQueryExecutor;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.Driver;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.Prepared;
import org.h2.command.dml.Insert;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.jdbc.JdbcStatement;
import org.h2.server.Service;
import org.h2.server.web.WebServer;
import org.h2.table.IndexColumn;
import org.h2.tools.Server;
import org.h2.util.JdbcUtils;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class IgniteH2Indexing
implements GridQueryIndexing {
    private static final String DB_OPTIONS;
    public static final List<GridQueryFieldMetadata> UPDATE_RESULT_META;
    private static final int PREPARED_STMT_CACHE_SIZE = 256;
    private static final int TWO_STEP_QRY_CACHE_SIZE = 1024;
    private final Long CLEANUP_STMT_CACHE_PERIOD = Long.getLong("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", 10000L);
    private final Long STATEMENT_CACHE_THREAD_USAGE_TIMEOUT = Long.getLong("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", 600000L);
    private GridTimeoutProcessor.CancelableTask stmtCacheCleanupTask;
    @LoggerResource
    private IgniteLogger log;
    private UUID nodeId;
    private Marshaller marshaller;
    private final ConcurrentMap<String, H2Schema> schemas = new ConcurrentHashMap8();
    private String dbUrl = "jdbc:h2:mem:";
    private final Collection<Connection> conns = Collections.synchronizedCollection(new ArrayList());
    private GridMapQueryExecutor mapQryExec;
    private GridReduceQueryExecutor rdcQryExec;
    private final Map<String, String> cacheName2schema = new ConcurrentHashMap8();
    private AtomicLong qryIdGen;
    private GridSpinBusyLock busyLock;
    private final ConcurrentMap<Long, GridRunningQueryInfo> runs = new ConcurrentHashMap8();
    private final ThreadLocal<H2ConnectionWrapper> connCache = new ThreadLocal<H2ConnectionWrapper>(){

        @Override
        @Nullable
        public H2ConnectionWrapper get() {
            H2ConnectionWrapper c = (H2ConnectionWrapper)super.get();
            boolean reconnect = true;
            try {
                reconnect = c == null || c.connection().isClosed();
            }
            catch (SQLException e) {
                U.warn((IgniteLogger)IgniteH2Indexing.this.log, (Object)"Failed to check connection status.", (Object)e);
            }
            if (reconnect) {
                c = this.initialValue();
                this.set(c);
                IgniteH2Indexing.this.stmtCache.remove(Thread.currentThread());
            }
            return c;
        }

        @Override
        @Nullable
        protected H2ConnectionWrapper initialValue() {
            Connection c;
            try {
                c = DriverManager.getConnection(IgniteH2Indexing.this.dbUrl);
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to initialize DB connection: " + IgniteH2Indexing.this.dbUrl, (Throwable)e);
            }
            IgniteH2Indexing.this.conns.add(c);
            return new H2ConnectionWrapper(c);
        }
    };
    protected volatile GridKernalContext ctx;
    protected CacheQueryObjectValueContext valCtx;
    private DmlStatementsProcessor dmlProc;
    private DdlStatementsProcessor ddlProc;
    private final ConcurrentMap<QueryTable, GridH2Table> dataTables = new ConcurrentHashMap8();
    private final ConcurrentHashMap<Thread, H2StatementCache> stmtCache = new ConcurrentHashMap();
    private final GridBoundedConcurrentLinkedHashMap<H2TwoStepCachedQueryKey, H2TwoStepCachedQuery> twoStepCache = new GridBoundedConcurrentLinkedHashMap(1024);
    private final IgniteInClosure<? super IgniteInternalFuture<?>> logger = new IgniteInClosure<IgniteInternalFuture<?>>(){

        public void apply(IgniteInternalFuture<?> fut) {
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)IgniteH2Indexing.this.log, (Object)e.getMessage(), (Throwable)e);
            }
        }
    };

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public Connection connectionForSchema(String schema) {
        try {
            return this.connectionForThread(schema);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private PreparedStatement prepareStatement(Connection c, String sql, boolean useStmtCache) throws SQLException {
        if (useStmtCache) {
            H2StatementCache cache0;
            Thread curThread = Thread.currentThread();
            H2StatementCache cache = this.stmtCache.get(curThread);
            if (cache == null && (cache = this.stmtCache.putIfAbsent(curThread, cache0 = new H2StatementCache(256))) == null) {
                cache = cache0;
            }
            cache.updateLastUsage();
            PreparedStatement stmt = (PreparedStatement)cache.get(sql);
            if (stmt != null && !stmt.isClosed() && !((JdbcStatement)stmt).isCancelled()) {
                assert (stmt.getConnection() == c);
                return stmt;
            }
            stmt = c.prepareStatement(sql);
            cache.put(sql, stmt);
            return stmt;
        }
        return c.prepareStatement(sql);
    }

    public PreparedStatement prepareNativeStatement(String schemaName, String sql) throws SQLException {
        Connection conn = this.connectionForSchema(schemaName);
        return this.prepareStatement(conn, sql, true);
    }

    private Connection connectionForThread(@Nullable String schema) throws IgniteCheckedException {
        H2ConnectionWrapper c = this.connCache.get();
        if (c == null) {
            throw new IgniteCheckedException("Failed to get DB connection for thread (check log for details).");
        }
        if (schema != null && !F.eq((Object)c.schema(), (Object)schema)) {
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                stmt.executeUpdate("SET SCHEMA " + H2Utils.withQuotes(schema));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set schema: " + schema);
                }
                c.schema(schema);
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to set schema for DB connection for thread [schema=" + schema + "]", (Throwable)e);
            }
            finally {
                U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
            }
        }
        return c.connection();
    }

    private void createSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "CREATE SCHEMA IF NOT EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created H2 schema for index database: " + schema);
        }
    }

    private void dropSchema(String schema) throws IgniteCheckedException {
        this.executeStatement("INFORMATION_SCHEMA", "DROP SCHEMA IF EXISTS " + H2Utils.withQuotes(schema));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dropped H2 schema for index database: " + schema);
        }
    }

    public void executeStatement(String schema, String sql) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            Connection c = this.connectionForThread(schema);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.onSqlException();
                throw new IgniteSQLException("Failed to execute statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (IgniteLogger)this.log);
                throw throwable;
            }
        }
        U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
    }

    private void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else if (obj instanceof BigInteger) {
                stmt.setObject(idx, obj, 2000);
            } else if (obj instanceof BigDecimal) {
                stmt.setObject(idx, obj, 3);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }

    private void onSqlException() {
        Connection conn = this.connCache.get().connection();
        this.connCache.set(null);
        if (conn != null) {
            this.conns.remove(conn);
            U.close((AutoCloseable)conn, (IgniteLogger)this.log);
        }
    }

    public void store(String cacheName, GridQueryTypeDescriptor type, KeyCacheObject k, int partId, CacheObject v, GridCacheVersion ver, long expirationTime, long link) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.tableDescriptor(this.schema(cacheName), cacheName, type.name());
        if (tbl == null) {
            return;
        }
        if (expirationTime == 0L) {
            expirationTime = Long.MAX_VALUE;
        }
        tbl.table().update(k, partId, v, ver, expirationTime, false, link);
        if (tbl.luceneIndex() != null) {
            tbl.luceneIndex().store((CacheObject)k, v, ver, expirationTime);
        }
    }

    public void remove(String cacheName, GridQueryTypeDescriptor type, KeyCacheObject key, int partId, CacheObject val, GridCacheVersion ver) throws IgniteCheckedException {
        H2TableDescriptor tbl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing key from cache query index [locId=" + this.nodeId + ", key=" + key + ", val=" + val + ']');
        }
        if ((tbl = this.tableDescriptor(this.schema(cacheName), cacheName, type.name())) == null) {
            return;
        }
        if (tbl.table().update(key, partId, val, ver, 0L, true, 0L) && tbl.luceneIndex() != null) {
            tbl.luceneIndex().remove((CacheObject)key);
        }
    }

    private void dropTable(H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        Connection c = this.connectionForThread(tbl.schemaName());
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropping database index table with SQL: " + sql);
            }
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteSQLException("Failed to drop database index table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", 3004, (Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
    }

    private void addInitialUserIndex(String schemaName, H2TableDescriptor desc, GridH2IndexBase h2Idx) throws IgniteCheckedException {
        GridH2Table h2Tbl = desc.table();
        h2Tbl.proposeUserIndex((Index)h2Idx);
        try {
            String sql = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, false);
            this.executeSql(schemaName, sql);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    public void dynamicIndexCreate(String schemaName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
        }
        GridH2Table h2Tbl = desc.table();
        final GridH2IndexBase h2Idx = desc.createUserIndex((GridQueryIndexDescriptor)idxDesc);
        h2Tbl.proposeUserIndex((Index)h2Idx);
        try {
            final GridH2RowDescriptor rowDesc = h2Tbl.rowDescriptor();
            SchemaIndexCacheVisitorClosure clo = new SchemaIndexCacheVisitorClosure(){

                public void apply(KeyCacheObject key, int part, CacheObject val, GridCacheVersion ver, long expTime, long link) throws IgniteCheckedException {
                    if (expTime == 0L) {
                        expTime = Long.MAX_VALUE;
                    }
                    GridH2Row row = rowDesc.createRow(key, part, val, ver, expTime);
                    row.link(link);
                    h2Idx.put(row);
                }
            };
            cacheVisitor.visit(clo);
            String sql = H2Utils.indexCreateSql(desc.fullTableName(), h2Idx, ifNotExists);
            this.executeSql(schemaName, sql);
        }
        catch (Exception e) {
            h2Tbl.rollbackUserIndex(h2Idx.getName());
            throw e;
        }
    }

    public void dynamicIndexDrop(String schemaName, String idxName, boolean ifExists) throws IgniteCheckedException {
        String sql = H2Utils.indexDropSql(schemaName, idxName, ifExists);
        this.executeSql(schemaName, sql);
    }

    public void dynamicAddColumn(String schemaName, String tblName, List<QueryField> cols, boolean ifTblExists, boolean ifColNotExists) throws IgniteCheckedException {
        H2TableDescriptor desc;
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor h2TableDescriptor = desc = schema != null ? schema.tableByName(tblName) : null;
        if (desc == null) {
            if (!ifTblExists) {
                throw new IgniteCheckedException("Table not found in internal H2 database [schemaName=" + schemaName + ", tblName=" + tblName + ']');
            }
            return;
        }
        desc.table().addColumns(cols, ifColNotExists);
        this.clearCachedQueries();
    }

    private void executeSql(String schemaName, String sql) throws IgniteCheckedException {
        try {
            Connection conn = this.connectionForSchema(schemaName);
            try (PreparedStatement stmt = this.prepareStatement(conn, sql, false);){
                stmt.execute();
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to execute SQL statement on internal H2 database: " + sql, (Throwable)e);
        }
    }

    public GridH2IndexBase createSortedIndex(String name, GridH2Table tbl, boolean pk, List<IndexColumn> cols, int inlineSize) {
        try {
            GridCacheContext cctx = tbl.cache();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating cache index [cacheId=" + cctx.cacheId() + ", idxName=" + name + ']');
            }
            int segments = tbl.rowDescriptor().context().config().getQueryParallelism();
            return new H2TreeIndex(cctx, tbl, name, pk, cols, inlineSize, segments);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalText(String schemaName, String cacheName, String qry, String typeName, IndexingQueryFilter filters) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.tableDescriptor(schemaName, cacheName, typeName);
        if (tbl != null && tbl.luceneIndex() != null) {
            GridRunningQueryInfo run = new GridRunningQueryInfo(Long.valueOf(this.qryIdGen.incrementAndGet()), qry, GridCacheQueryType.TEXT, schemaName, U.currentTimeMillis(), null, true);
            try {
                this.runs.put(run.id(), run);
                GridCloseableIterator gridCloseableIterator = tbl.luceneIndex().query(qry, filters);
                return gridCloseableIterator;
            }
            finally {
                this.runs.remove(run.id());
            }
        }
        return new GridEmptyCloseableIterator();
    }

    public GridQueryFieldsResult queryLocalSqlFields(final String schemaName, final String qry, final @Nullable Collection<Object> params, IndexingQueryFilter filter, boolean enforceJoinOrder, final int timeout, final GridQueryCancel cancel) throws IgniteCheckedException {
        List<GridQueryFieldMetadata> meta;
        final Connection conn = this.connectionForSchema(schemaName);
        H2Utils.setupConnection(conn, false, enforceJoinOrder);
        final PreparedStatement stmt = this.preparedStatementWithParams(conn, qry, params, true);
        Prepared p = GridSqlQueryParser.prepared(stmt);
        if (DmlStatementsProcessor.isDmlStatement(p)) {
            SqlFieldsQuery fldsQry = new SqlFieldsQuery(qry);
            if (params != null) {
                fldsQry.setArgs(params.toArray());
            }
            fldsQry.setEnforceJoinOrder(enforceJoinOrder);
            fldsQry.setTimeout(timeout, TimeUnit.MILLISECONDS);
            return this.dmlProc.updateSqlFieldsLocal(schemaName, conn, stmt, fldsQry, filter, cancel);
        }
        if (DdlStatementsProcessor.isDdlStatement(p)) {
            throw new IgniteSQLException("DDL statements are supported for the whole cluster only", 1002);
        }
        try {
            meta = H2Utils.meta(stmt.getMetaData());
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Cannot prepare query metadata", (Throwable)e);
        }
        final GridH2QueryContext ctx = new GridH2QueryContext(this.nodeId, this.nodeId, 0L, GridH2QueryType.LOCAL).filter(filter).distributedJoinMode(DistributedJoinMode.OFF);
        return new GridQueryFieldsResultAdapter(meta, null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public GridCloseableIterator<List<?>> iterator() throws IgniteCheckedException {
                assert (GridH2QueryContext.get() == null);
                GridH2QueryContext.set(ctx);
                GridRunningQueryInfo run = new GridRunningQueryInfo(Long.valueOf(IgniteH2Indexing.this.qryIdGen.incrementAndGet()), qry, GridCacheQueryType.SQL_FIELDS, schemaName, U.currentTimeMillis(), cancel, true);
                IgniteH2Indexing.this.runs.putIfAbsent(run.id(), run);
                try {
                    ResultSet rs = IgniteH2Indexing.this.executeSqlQueryWithTimer(stmt, conn, qry, params, timeout, cancel);
                    H2FieldsIterator h2FieldsIterator = new H2FieldsIterator(rs);
                    return h2FieldsIterator;
                }
                finally {
                    GridH2QueryContext.clearThreadLocal();
                    IgniteH2Indexing.this.runs.remove(run.id());
                }
            }
        };
    }

    public long streamUpdateQuery(String schemaName, String qry, @Nullable Object[] params, IgniteDataStreamer<?, ?> streamer) throws IgniteCheckedException {
        PreparedStatement stmt;
        Connection conn = this.connectionForSchema(schemaName);
        try {
            stmt = this.prepareStatement(conn, qry, true);
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
        return this.dmlProc.streamUpdateQuery(streamer, stmt, params);
    }

    private PreparedStatement preparedStatementWithParams(Connection conn, String sql, Collection<Object> params, boolean useStmtCache) throws IgniteCheckedException {
        PreparedStatement stmt;
        try {
            stmt = this.prepareStatement(conn, sql, useStmtCache);
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to parse SQL query: " + sql, (Throwable)e);
        }
        this.bindParameters(stmt, params);
        return stmt;
    }

    private ResultSet executeSqlQuery(Connection conn, final PreparedStatement stmt, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        final MapQueryLazyWorker lazyWorker = MapQueryLazyWorker.currentWorker();
        if (cancel != null) {
            cancel.set(new Runnable(){

                @Override
                public void run() {
                    if (lazyWorker != null) {
                        lazyWorker.submit(new Runnable(){

                            @Override
                            public void run() {
                                IgniteH2Indexing.cancelStatement(stmt);
                            }
                        });
                    } else {
                        IgniteH2Indexing.cancelStatement(stmt);
                    }
                }
            });
        }
        Session ses = H2Utils.session(conn);
        if (timeoutMillis > 0) {
            ses.setQueryTimeout(timeoutMillis);
        }
        if (lazyWorker != null) {
            ses.setLazyQueryExecution(true);
        }
        try {
            ResultSet resultSet = stmt.executeQuery();
            return resultSet;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 57014) {
                throw new QueryCancelledException();
            }
            throw new IgniteCheckedException("Failed to execute SQL query.", (Throwable)e);
        }
        finally {
            if (timeoutMillis > 0) {
                ses.setQueryTimeout(0);
            }
            if (lazyWorker != null) {
                ses.setLazyQueryExecution(false);
            }
        }
    }

    private static void cancelStatement(PreparedStatement stmt) {
        try {
            stmt.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ResultSet executeSqlQueryWithTimer(Connection conn, String sql, @Nullable Collection<Object> params, boolean useStmtCache, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        return this.executeSqlQueryWithTimer(this.preparedStatementWithParams(conn, sql, params, useStmtCache), conn, sql, params, timeoutMillis, cancel);
    }

    private ResultSet executeSqlQueryWithTimer(PreparedStatement stmt, Connection conn, String sql, @Nullable Collection<Object> params, int timeoutMillis, @Nullable GridQueryCancel cancel) throws IgniteCheckedException {
        long start = U.currentTimeMillis();
        try {
            ResultSet rs = this.executeSqlQuery(conn, stmt, timeoutMillis, cancel);
            long time = U.currentTimeMillis() - start;
            long longQryExecTimeout = this.ctx.config().getLongQueryWarningTimeout();
            if (time > longQryExecTimeout) {
                String msg = "Query execution is too long (" + time + " ms): " + sql;
                ResultSet plan = this.executeSqlQuery(conn, this.preparedStatementWithParams(conn, "EXPLAIN " + sql, params, false), 0, null);
                plan.next();
                String longMsg = "Query execution is too long [time=" + time + " ms, sql='" + sql + '\'' + ", plan=" + U.nl() + plan.getString(1) + U.nl() + ", parameters=" + (params == null ? "[]" : Arrays.deepToString(params.toArray())) + "]";
                LT.warn((IgniteLogger)this.log, (String)longMsg, (String)msg);
            }
            return rs;
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                this.bindObject(stmt, idx++, arg);
            }
        }
    }

    public FieldsQueryCursor<List<?>> queryLocalSqlFields(String schemaName, SqlFieldsQuery qry, final boolean keepBinary, IndexingQueryFilter filter, GridQueryCancel cancel) throws IgniteCheckedException {
        String sql = qry.getSql();
        Object[] args = qry.getArgs();
        final GridQueryFieldsResult res = this.queryLocalSqlFields(schemaName, sql, F.asList((Object[])args), filter, qry.isEnforceJoinOrder(), qry.getTimeout(), cancel);
        QueryCursorImpl cursor = new QueryCursorImpl(new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                try {
                    return new GridQueryCacheObjectsIterator((Iterator)res.iterator(), IgniteH2Indexing.this.objectContext(), keepBinary);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        }, cancel);
        cursor.fieldsMeta(res.metaData());
        return cursor;
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryLocalSql(String schemaName, String cacheName, SqlQuery qry, IndexingQueryFilter filter, final boolean keepBinary) throws IgniteCheckedException {
        String type = qry.getType();
        String sqlQry = qry.getSql();
        String alias = qry.getAlias();
        Object[] params = qry.getArgs();
        GridQueryCancel cancel = new GridQueryCancel();
        final GridCloseableIterator<IgniteBiTuple<K, V>> i = this.queryLocalSql(schemaName, cacheName, sqlQry, alias, F.asList((Object[])params), type, filter, cancel);
        return new QueryCursorImpl(new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                return new ClIter<Cache.Entry<K, V>>(){

                    @Override
                    public void close() throws Exception {
                        i.close();
                    }

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        IgniteBiTuple t = (IgniteBiTuple)i.next();
                        Object key = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)IgniteH2Indexing.this.objectContext(), (Object)t.get1(), (boolean)keepBinary, (boolean)false);
                        Object val = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)IgniteH2Indexing.this.objectContext(), (Object)t.get2(), (boolean)keepBinary, (boolean)false);
                        return new CacheEntryImpl(key, val);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> GridCloseableIterator<IgniteBiTuple<K, V>> queryLocalSql(String schemaName, String cacheName, String qry, String alias, @Nullable Collection<Object> params, String type, IndexingQueryFilter filter, GridQueryCancel cancel) throws IgniteCheckedException {
        H2TableDescriptor tbl = this.tableDescriptor(schemaName, cacheName, type);
        if (tbl == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        String sql = this.generateQuery(qry, alias, tbl);
        Connection conn = this.connectionForThread(tbl.schemaName());
        H2Utils.setupConnection(conn, false, false);
        GridH2QueryContext.set(new GridH2QueryContext(this.nodeId, this.nodeId, 0L, GridH2QueryType.LOCAL).filter(filter).distributedJoinMode(DistributedJoinMode.OFF));
        GridRunningQueryInfo run = new GridRunningQueryInfo(Long.valueOf(this.qryIdGen.incrementAndGet()), qry, GridCacheQueryType.SQL, schemaName, U.currentTimeMillis(), null, true);
        this.runs.put(run.id(), run);
        try {
            ResultSet rs = this.executeSqlQueryWithTimer(conn, sql, params, true, 0, cancel);
            H2KeyValueIterator h2KeyValueIterator = new H2KeyValueIterator(rs);
            return h2KeyValueIterator;
        }
        finally {
            GridH2QueryContext.clearThreadLocal();
            this.runs.remove(run.id());
        }
    }

    private Iterable<List<?>> runQueryTwoStep(final String schemaName, final GridCacheTwoStepQuery qry, final boolean keepCacheObj, final boolean enforceJoinOrder, final int timeoutMillis, final GridQueryCancel cancel, final Object[] params, final int[] parts, final boolean lazy) {
        return new Iterable<List<?>>(){

            @Override
            public Iterator<List<?>> iterator() {
                return IgniteH2Indexing.this.rdcQryExec.query(schemaName, qry, keepCacheObj, enforceJoinOrder, timeoutMillis, cancel, params, parts, lazy);
            }
        };
    }

    UpdateResult runDistributedUpdate(String schemaName, SqlFieldsQuery fieldsQry, List<Integer> cacheIds, boolean isReplicatedOnly, GridQueryCancel cancel) {
        return this.rdcQryExec.update(schemaName, cacheIds, fieldsQry.getSql(), fieldsQry.getArgs(), fieldsQry.isEnforceJoinOrder(), fieldsQry.getPageSize(), fieldsQry.getTimeout(), fieldsQry.getPartitions(), isReplicatedOnly, cancel);
    }

    public <K, V> QueryCursor<Cache.Entry<K, V>> queryDistributedSql(String schemaName, String cacheName, SqlQuery qry, boolean keepBinary, int mainCacheId) {
        String sql;
        String type = qry.getType();
        H2TableDescriptor tblDesc = this.tableDescriptor(schemaName, cacheName, type);
        if (tblDesc == null) {
            throw new IgniteSQLException("Failed to find SQL table for type: " + type, 3001);
        }
        try {
            sql = this.generateQuery(qry.getSql(), qry.getAlias(), tblDesc);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        SqlFieldsQuery fqry = new SqlFieldsQuery(sql);
        fqry.setArgs(qry.getArgs());
        fqry.setPageSize(qry.getPageSize());
        fqry.setDistributedJoins(qry.isDistributedJoins());
        fqry.setPartitions(qry.getPartitions());
        fqry.setLocal(qry.isLocal());
        if (qry.getTimeout() > 0) {
            fqry.setTimeout(qry.getTimeout(), TimeUnit.MILLISECONDS);
        }
        final QueryCursor res = (QueryCursor)this.queryDistributedSqlFields(schemaName, fqry, keepBinary, null, mainCacheId, true).get(0);
        Iterable converted = new Iterable<Cache.Entry<K, V>>(){

            @Override
            public Iterator<Cache.Entry<K, V>> iterator() {
                final Iterator iter0 = res.iterator();
                return new Iterator<Cache.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iter0.hasNext();
                    }

                    @Override
                    public Cache.Entry<K, V> next() {
                        List l = (List)iter0.next();
                        return new CacheEntryImpl(l.get(0), l.get(1));
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return new QueryCursorImpl<Cache.Entry<K, V>>(converted){

            public void close() {
                res.close();
            }
        };
    }

    /*
     * Exception decompiling
     */
    public List<FieldsQueryCursor<List<?>>> queryDistributedSqlFields(String schemaName, SqlFieldsQuery qry, boolean keepBinary, GridQueryCancel cancel, @Nullable Integer mainCacheId, boolean failOnMultipleStmts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 14[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkQueryType(SqlFieldsQuery qry, boolean isQry) {
        if (qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isQuery() != null && ((SqlFieldsQueryEx)qry).isQuery() != isQry) {
            throw new IgniteSQLException("Given statement type does not match that declared by JDBC driver", 3003);
        }
    }

    private FieldsQueryCursor<List<?>> executeTwoStepsQuery(String schemaName, int pageSize, int[] partitions, Object[] args, boolean keepBinary, boolean lazy, int timeout, GridQueryCancel cancel, String sqlQry, boolean enforceJoinOrder, GridCacheTwoStepQuery twoStepQry, List<GridQueryFieldMetadata> meta) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parsed query: `" + sqlQry + "` into two step query: " + twoStepQry);
        }
        twoStepQry.pageSize(pageSize);
        if (cancel == null) {
            cancel = new GridQueryCancel();
        }
        if (partitions == null && twoStepQry.derivedPartitions() != null) {
            try {
                partitions = this.calculateQueryPartitions(twoStepQry.derivedPartitions(), args);
            }
            catch (IgniteCheckedException e) {
                throw new CacheException("Failed to calculate derived partitions: [qry=" + sqlQry + ", params=" + Arrays.deepToString(args) + "]", (Throwable)e);
            }
        }
        QueryCursorImpl cursor = new QueryCursorImpl(this.runQueryTwoStep(schemaName, twoStepQry, keepBinary, enforceJoinOrder, timeout, cancel, args, partitions, lazy), cancel);
        cursor.fieldsMeta(meta);
        return cursor;
    }

    public UpdateResult mapDistributedUpdate(String schemaName, SqlFieldsQuery fldsQry, IndexingQueryFilter filter, GridQueryCancel cancel, boolean local) throws IgniteCheckedException {
        Connection conn = this.connectionForSchema(schemaName);
        H2Utils.setupConnection(conn, false, fldsQry.isEnforceJoinOrder());
        PreparedStatement stmt = this.preparedStatementWithParams(conn, fldsQry.getSql(), Arrays.asList(fldsQry.getArgs()), true);
        return this.dmlProc.mapDistributedUpdate(schemaName, stmt, fldsQry, filter, cancel, local);
    }

    private void checkCacheIndexSegmentation(List<Integer> cacheIds) {
        if (cacheIds.isEmpty()) {
            return;
        }
        GridCacheSharedContext sharedCtx = this.ctx.cache().context();
        int expectedParallelism = 0;
        for (Integer cacheId : cacheIds) {
            GridCacheContext cctx = sharedCtx.cacheContext(cacheId.intValue());
            assert (cctx != null);
            if (!cctx.isPartitioned()) continue;
            if (expectedParallelism == 0) {
                expectedParallelism = cctx.config().getQueryParallelism();
                continue;
            }
            if (cctx.config().getQueryParallelism() == expectedParallelism) continue;
            throw new IllegalStateException("Using indexes with different parallelism levels in same query is forbidden.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateQuery(String qry, String tableAlias, H2TableDescriptor tbl) throws IgniteCheckedException {
        assert (tbl != null);
        String qry0 = qry;
        String t = tbl.fullTableName();
        String from = " ";
        String upper = (qry = qry.trim()).toUpperCase();
        if (upper.startsWith("SELECT")) {
            int star = (qry = qry.substring(6).trim()).indexOf(42);
            if (star == 0) {
                qry = qry.substring(1).trim();
            } else {
                if (star <= 0) throw new IgniteCheckedException("Only queries starting with 'SELECT *' and 'SELECT alias.*' are supported (rewrite your query or use SqlFieldsQuery instead): " + qry0);
                if (!F.eq((Object)Character.valueOf('.'), (Object)Character.valueOf(qry.charAt(star - 1)))) throw new IgniteCheckedException("Invalid query (missing alias before asterisk): " + qry0);
                t = qry.substring(0, star - 1);
                qry = qry.substring(star + 1).trim();
            }
            upper = qry.toUpperCase();
        }
        if (!upper.startsWith("FROM")) {
            from = " FROM " + t + (tableAlias != null ? " as " + tableAlias : "") + (upper.startsWith("WHERE") || upper.startsWith("ORDER") || upper.startsWith("LIMIT") ? " " : " WHERE ");
        }
        if (tableAlias == null) return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
        t = tableAlias;
        return "SELECT " + t + "." + "_KEY" + ", " + t + "." + "_VAL" + from + qry;
    }

    public boolean registerType(GridCacheContext cctx, GridQueryTypeDescriptor type) throws IgniteCheckedException {
        this.validateTypeDescriptor(type);
        String schemaName = this.schema(cctx.name());
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        H2TableDescriptor tbl = new H2TableDescriptor(this, schema, type, cctx);
        try {
            Connection conn = this.connectionForThread(schemaName);
            this.createTable(schemaName, schema, tbl, conn);
            schema.add(tbl);
        }
        catch (SQLException e) {
            this.onSqlException();
            throw new IgniteCheckedException("Failed to register query type: " + type, (Throwable)e);
        }
        return true;
    }

    private void validateTypeDescriptor(GridQueryTypeDescriptor type) throws IgniteCheckedException {
        assert (type != null);
        HashSet names = new HashSet();
        names.addAll(type.fields().keySet());
        if (names.size() < type.fields().size()) {
            throw new IgniteCheckedException("Found duplicated properties with the same name [keyType=" + type.keyClass().getName() + ", valueType=" + type.valueClass().getName() + "]");
        }
        String ptrn = "Name ''{0}'' is reserved and cannot be used as a field name [type=" + type.name() + "]";
        for (String name : names) {
            if (!name.equalsIgnoreCase("_KEY") && !name.equalsIgnoreCase("_VAL") && !name.equalsIgnoreCase("_VER")) continue;
            throw new IgniteCheckedException(MessageFormat.format(ptrn, name));
        }
    }

    private void createTable(String schemaName, H2Schema schema, H2TableDescriptor tbl, Connection conn) throws SQLException, IgniteCheckedException {
        assert (schema != null);
        assert (tbl != null);
        String keyType = this.dbTypeFromClass(tbl.type().keyClass());
        String valTypeStr = this.dbTypeFromClass(tbl.type().valueClass());
        SB sql = new SB();
        String keyValVisibility = tbl.type().fields().isEmpty() ? " VISIBLE" : " INVISIBLE";
        sql.a("CREATE TABLE ").a(tbl.fullTableName()).a(" (").a("_KEY").a(' ').a(keyType).a(keyValVisibility).a(" NOT NULL");
        sql.a(',').a("_VAL").a(' ').a(valTypeStr).a(keyValVisibility);
        sql.a(',').a("_VER").a(" OTHER INVISIBLE");
        for (Map.Entry e : tbl.type().fields().entrySet()) {
            sql.a(',').a(H2Utils.withQuotes((String)e.getKey())).a(' ').a(this.dbTypeFromClass((Class)e.getValue())).a(tbl.type().property((String)e.getKey()).notNull() ? " NOT NULL" : "");
        }
        sql.a(')');
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        H2RowDescriptor rowDesc = new H2RowDescriptor(this, tbl, tbl.type());
        H2RowFactory rowFactory = tbl.rowFactory(rowDesc);
        GridH2Table h2Tbl = H2TableEngine.createTable(conn, sql.toString(), rowDesc, rowFactory, tbl);
        for (GridH2IndexBase usrIdx : tbl.createUserIndexes()) {
            this.addInitialUserIndex(schemaName, tbl, usrIdx);
        }
        if (this.dataTables.putIfAbsent(h2Tbl.identifier(), h2Tbl) != null) {
            throw new IllegalStateException("Table already exists: " + h2Tbl.identifierString());
        }
    }

    public GridH2Table dataTable(String schemaName, String tblName) {
        return this.dataTable(new QueryTable(schemaName, tblName));
    }

    public GridH2Table dataTable(QueryTable tbl) {
        return (GridH2Table)((Object)this.dataTables.get(tbl));
    }

    public void removeDataTable(GridH2Table h2Tbl) {
        this.dataTables.remove(h2Tbl.identifier(), (Object)h2Tbl);
    }

    public GridH2Table dataTableForIndex(String schemaName, String idxName) {
        for (Map.Entry dataTableEntry : this.dataTables.entrySet()) {
            GridH2Table h2Tbl;
            if (!F.eq((Object)((QueryTable)dataTableEntry.getKey()).schema(), (Object)schemaName) || !(h2Tbl = (GridH2Table)((Object)dataTableEntry.getValue())).containsUserIndex(idxName)) continue;
            return h2Tbl;
        }
        return null;
    }

    private String dbTypeFromClass(Class<?> cls) {
        return H2DatabaseType.fromClass(cls).dBTypeAsString();
    }

    @Nullable
    private H2TableDescriptor tableDescriptor(String schemaName, String cacheName, String type) {
        H2Schema schema = (H2Schema)this.schemas.get(schemaName);
        if (schema == null) {
            return null;
        }
        return schema.tableByTypeName(cacheName, type);
    }

    public String schema(String cacheName) {
        String res = this.cacheName2schema.get(cacheName);
        if (res == null) {
            res = "";
        }
        return res;
    }

    private Collection<H2TableDescriptor> tables(String cacheName) {
        H2Schema s = (H2Schema)this.schemas.get(this.schema(cacheName));
        if (s == null) {
            return Collections.emptySet();
        }
        ArrayList<H2TableDescriptor> tbls = new ArrayList<H2TableDescriptor>();
        for (H2TableDescriptor tbl : s.tables()) {
            if (!F.eq((Object)tbl.cache().name(), (Object)cacheName)) continue;
            tbls.add(tbl);
        }
        return tbls;
    }

    public boolean isInsertStatement(PreparedStatement nativeStmt) {
        Prepared prep = GridSqlQueryParser.prepared(nativeStmt);
        return prep instanceof Insert;
    }

    private void cleanupStatementCache() {
        long cur = U.currentTimeMillis();
        Iterator<Map.Entry<Thread, H2StatementCache>> it = this.stmtCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Thread, H2StatementCache> entry = it.next();
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.TERMINATED && cur - entry.getValue().lastUsage() <= this.STATEMENT_CACHE_THREAD_USAGE_TIMEOUT) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildIndexesFromHash(String cacheName) throws IgniteCheckedException {
        int cacheId = CU.cacheId((String)cacheName);
        GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheId);
        IgniteCacheOffheapManager offheapMgr = cctx.isNear() ? cctx.near().dht().context().offheap() : cctx.offheap();
        for (int p = 0; p < cctx.affinity().partitions(); ++p) {
            try (GridCloseableIterator keyIter = offheapMgr.cacheKeysIterator(cctx.cacheId(), p);){
                block20: while (keyIter.hasNext()) {
                    cctx.shared().database().checkpointReadLock();
                    try {
                        GridCacheEntryEx entry;
                        KeyCacheObject key = (KeyCacheObject)keyIter.next();
                        while (true) {
                            entry = null;
                            try {
                                entry = cctx.isNear() ? cctx.near().dht().entryEx(key) : cctx.cache().entryEx(key);
                                entry.ensureIndexed();
                                continue block20;
                            }
                            catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                                continue;
                            }
                            catch (GridDhtInvalidPartitionException ignore) {
                                continue block20;
                            }
                            break;
                        }
                        finally {
                            entry.context().evicts().touch(entry, AffinityTopologyVersion.NONE);
                        }
                    }
                    finally {
                        cctx.shared().database().checkpointReadUnlock();
                    }
                }
                continue;
            }
        }
        Iterator<H2TableDescriptor> i$ = this.tables(cacheName).iterator();
        while (i$.hasNext()) {
            H2TableDescriptor tblDesc = i$.next();
            tblDesc.table().markRebuildFromHashInProgress(false);
        }
        return;
    }

    public void markForRebuildFromHash(String cacheName) {
        for (H2TableDescriptor tblDesc : this.tables(cacheName)) {
            assert (tblDesc.table() != null);
            tblDesc.table().markRebuildFromHashInProgress(true);
        }
    }

    public GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    public GridMapQueryExecutor mapQueryExecutor() {
        return this.mapQryExec;
    }

    public GridReduceQueryExecutor reduceQueryExecutor() {
        return this.rdcQryExec;
    }

    public void start(GridKernalContext ctx, GridSpinBusyLock busyLock) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting cache query index...");
        }
        this.busyLock = busyLock;
        this.qryIdGen = new AtomicLong();
        if (SysProperties.serializeJavaObject) {
            U.warn((IgniteLogger)this.log, (Object)"Serialization of Java objects in H2 was enabled.");
            SysProperties.serializeJavaObject = false;
        }
        String dbName = (ctx != null ? ctx.localNodeId() : UUID.randomUUID()).toString();
        this.dbUrl = "jdbc:h2:mem:" + dbName + DB_OPTIONS;
        Driver.load();
        try {
            if (IgniteSystemProperties.getString((String)"IGNITE_H2_DEBUG_CONSOLE") != null) {
                Connection c = DriverManager.getConnection(this.dbUrl);
                int port = IgniteSystemProperties.getInteger((String)"IGNITE_H2_DEBUG_CONSOLE_PORT", (int)0);
                WebServer webSrv = new WebServer();
                Server web = new Server((Service)webSrv, new String[]{"-webPort", Integer.toString(port)});
                web.start();
                String url = webSrv.addSession(c);
                U.quietAndInfo((IgniteLogger)this.log, (String)("H2 debug console URL: " + url));
                try {
                    Server.openBrowser((String)url);
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Failed to open browser: " + e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        if (ctx == null) {
            this.nodeId = UUID.randomUUID();
            this.marshaller = new JdkMarshaller();
        } else {
            this.ctx = ctx;
            this.schemas.put("PUBLIC", new H2Schema("PUBLIC"));
            this.valCtx = new CacheQueryObjectValueContext(ctx);
            this.nodeId = ctx.localNodeId();
            this.marshaller = ctx.config().getMarshaller();
            this.mapQryExec = new GridMapQueryExecutor(busyLock);
            this.rdcQryExec = new GridReduceQueryExecutor(this.qryIdGen, busyLock);
            this.mapQryExec.start(ctx, this);
            this.rdcQryExec.start(ctx, this);
            this.stmtCacheCleanupTask = ctx.timeout().schedule(new Runnable(){

                @Override
                public void run() {
                    IgniteH2Indexing.this.cleanupStatementCache();
                }
            }, this.CLEANUP_STMT_CACHE_PERIOD.longValue(), this.CLEANUP_STMT_CACHE_PERIOD.longValue());
            this.dmlProc = new DmlStatementsProcessor();
            this.ddlProc = new DdlStatementsProcessor();
            this.dmlProc.start(ctx, this);
            this.ddlProc.start(ctx, this);
        }
        if (JdbcUtils.serializer != null) {
            U.warn((IgniteLogger)this.log, (Object)"Custom H2 serialization is already configured, will override.");
        }
        JdbcUtils.serializer = this.h2Serializer();
    }

    public CacheObjectValueContext objectContext() {
        return this.ctx.query().objectContext();
    }

    public boolean send(Object topic, int topicOrd, Collection<ClusterNode> nodes, Message msg, @Nullable IgniteBiClosure<ClusterNode, Message, Message> specialize, final @Nullable IgniteInClosure2X<ClusterNode, Message> locNodeHnd, byte plc, boolean runLocParallel) {
        boolean ok = true;
        if (specialize == null && msg instanceof GridCacheQueryMarshallable) {
            ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
        }
        ClusterNode locNode = null;
        for (ClusterNode node : nodes) {
            if (node.isLocal()) {
                if (locNode != null) {
                    throw new IllegalStateException();
                }
                locNode = node;
                continue;
            }
            try {
                if (specialize != null && (msg = (Message)specialize.apply((Object)node, (Object)msg)) instanceof GridCacheQueryMarshallable) {
                    ((GridCacheQueryMarshallable)msg).marshall(this.marshaller);
                }
                this.ctx.io().sendGeneric(node, topic, topicOrd, msg, plc);
            }
            catch (IgniteCheckedException e) {
                ok = false;
                U.warn((IgniteLogger)this.log, (Object)("Failed to send message [node=" + node + ", msg=" + msg + ", errMsg=" + e.getMessage() + "]"));
            }
        }
        if (locNode != null) {
            assert (locNodeHnd != null);
            if (specialize != null) {
                msg = (Message)specialize.apply(locNode, (Object)msg);
            }
            if (runLocParallel) {
                final ClusterNode finalLocNode = locNode;
                final Message finalMsg = msg;
                try {
                    this.ctx.closure().runLocal((Runnable)new GridPlainRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (!IgniteH2Indexing.this.busyLock.enterBusy()) {
                                return;
                            }
                            try {
                                locNodeHnd.apply((Object)finalLocNode, (Object)finalMsg);
                            }
                            finally {
                                IgniteH2Indexing.this.busyLock.leaveBusy();
                            }
                        }
                    }, plc).listen(this.logger);
                }
                catch (IgniteCheckedException e) {
                    ok = false;
                    U.error((IgniteLogger)this.log, (Object)"Failed to execute query locally.", (Throwable)e);
                }
            } else {
                locNodeHnd.apply((Object)locNode, (Object)msg);
            }
        }
        return ok;
    }

    private JavaObjectSerializer h2Serializer() {
        return new JavaObjectSerializer(){

            public byte[] serialize(Object obj) throws Exception {
                return U.marshal((Marshaller)IgniteH2Indexing.this.marshaller, (Object)obj);
            }

            public Object deserialize(byte[] bytes) throws Exception {
                ClassLoader clsLdr = IgniteH2Indexing.this.ctx != null ? U.resolveClassLoader((IgniteConfiguration)IgniteH2Indexing.this.ctx.config()) : null;
                return U.unmarshal((Marshaller)IgniteH2Indexing.this.marshaller, (byte[])bytes, (ClassLoader)clsLdr);
            }
        };
    }

    private void createSqlFunctions(String schema, Class<?>[] clss) throws IgniteCheckedException {
        if (F.isEmpty((Object[])clss)) {
            return;
        }
        for (Class<?> cls : clss) {
            for (Method m : cls.getDeclaredMethods()) {
                QuerySqlFunction ann = m.getAnnotation(QuerySqlFunction.class);
                if (ann == null) continue;
                int modifiers = m.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
                    throw new IgniteCheckedException("Method " + m.getName() + " must be public static.");
                }
                String alias = ann.alias().isEmpty() ? m.getName() : ann.alias();
                String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (ann.deterministic() ? " DETERMINISTIC FOR \"" : " FOR \"") + cls.getName() + '.' + m.getName() + '\"';
                this.executeStatement(schema, clause);
            }
        }
    }

    public void stop() throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping cache query index...");
        }
        this.mapQryExec.cancelLazyWorkers();
        if (this.ctx != null && !this.ctx.cache().context().database().persistenceEnabled()) {
            for (H2Schema schema : this.schemas.values()) {
                schema.dropAll();
            }
        }
        for (Connection c : this.conns) {
            U.close((AutoCloseable)c, (IgniteLogger)this.log);
        }
        this.conns.clear();
        this.schemas.clear();
        this.cacheName2schema.clear();
        try (Connection c = DriverManager.getConnection(this.dbUrl);
             Statement s = c.createStatement();){
            s.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to shutdown database.", (Throwable)e);
        }
        if (this.stmtCacheCleanupTask != null) {
            this.stmtCacheCleanupTask.close();
        }
        GridH2QueryContext.clearLocalNodeStop(this.nodeId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cache query index stopped.");
        }
    }

    private boolean isDefaultSchema(String schemaName) {
        return F.eq((Object)schemaName, (Object)"PUBLIC");
    }

    public void registerCache(String cacheName, String schemaName, GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        if (!this.isDefaultSchema(schemaName)) {
            if (this.schemas.putIfAbsent(schemaName, new H2Schema(schemaName)) != null) {
                throw new IgniteCheckedException("Schema already registered: " + U.maskName((String)schemaName));
            }
            this.createSchema(schemaName);
        }
        this.cacheName2schema.put(cacheName, schemaName);
        this.createSqlFunctions(schemaName, cctx.config().getSqlFunctionClasses());
    }

    public void unregisterCache(String cacheName, boolean destroy) {
        H2Schema schema;
        String schemaName = this.schema(cacheName);
        boolean dflt = this.isDefaultSchema(schemaName);
        H2Schema h2Schema = schema = dflt ? (H2Schema)this.schemas.get(schemaName) : (H2Schema)this.schemas.remove(schemaName);
        if (schema != null) {
            this.mapQryExec.onCacheStop(cacheName);
            this.dmlProc.onCacheStop(cacheName);
            this.cacheName2schema.remove(cacheName);
            HashSet<H2TableDescriptor> rmvTbls = new HashSet<H2TableDescriptor>();
            for (H2TableDescriptor tbl : schema.tables()) {
                if (!F.eq((Object)tbl.cache().name(), (Object)cacheName)) continue;
                try {
                    boolean removeIdx = !this.ctx.cache().context().database().persistenceEnabled() || destroy;
                    tbl.table().setRemoveIndexOnDestroy(removeIdx);
                    this.dropTable(tbl);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to drop table on cache stop (will ignore): " + tbl.fullTableName()), (Throwable)e);
                }
                schema.drop(tbl);
                rmvTbls.add(tbl);
            }
            if (!dflt) {
                try {
                    this.dropSchema(schemaName);
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to drop schema on cache stop (will ignore): " + cacheName), (Throwable)e);
                }
            }
            this.stmtCache.clear();
            for (H2TableDescriptor tbl : rmvTbls) {
                for (Index idx : tbl.table().getIndexes()) {
                    idx.close(null);
                }
            }
            int cacheId = CU.cacheId((String)cacheName);
            Iterator it = this.twoStepCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                GridCacheTwoStepQuery qry = ((H2TwoStepCachedQuery)e.getValue()).query();
                if (F.isEmpty(qry.cacheIds()) || !qry.cacheIds().contains(cacheId)) continue;
                it.remove();
            }
        }
    }

    private void clearCachedQueries() {
        this.twoStepCache.clear();
    }

    public IndexingQueryFilter backupFilter(final @Nullable AffinityTopologyVersion topVer, final @Nullable int[] parts) {
        final AffinityTopologyVersion topVer0 = topVer != null ? topVer : AffinityTopologyVersion.NONE;
        return new IndexingQueryFilter(){

            @Nullable
            public <K, V> IgniteBiPredicate<K, V> forCache(String cacheName) {
                GridCacheAdapter cache = IgniteH2Indexing.this.ctx.cache().internalCache(cacheName);
                if (cache.context().isReplicated()) {
                    return null;
                }
                final GridCacheAffinityManager aff = cache.context().affinity();
                if (parts != null) {
                    if (parts.length < 64) {
                        return new IgniteBiPredicate<K, V>(){

                            public boolean apply(K k, V v) {
                                int p = aff.partition(k);
                                for (int p0 : parts) {
                                    if (p0 == p) {
                                        return true;
                                    }
                                    if (p0 <= p) continue;
                                    return false;
                                }
                                return false;
                            }
                        };
                    }
                    return new IgniteBiPredicate<K, V>(){

                        public boolean apply(K k, V v) {
                            int p = aff.partition(k);
                            return Arrays.binarySearch(parts, p) >= 0;
                        }
                    };
                }
                final ClusterNode locNode = IgniteH2Indexing.this.ctx.discovery().localNode();
                return new IgniteBiPredicate<K, V>(){

                    public boolean apply(K k, V v) {
                        return aff.primaryByKey(locNode, k, topVer0);
                    }
                };
            }

            public boolean isValueRequired() {
                return false;
            }

            public String toString() {
                return "IndexingQueryFilter [ver=" + topVer + ']';
            }
        };
    }

    public AffinityTopologyVersion readyTopologyVersion() {
        return this.ctx.cache().context().exchange().readyAffinityVersion();
    }

    public void awaitForReadyTopologyVersion(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        IgniteInternalFuture fut = this.ctx.cache().context().exchange().affinityReadyFuture(topVer);
        if (fut != null) {
            fut.get();
        }
    }

    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.rdcQryExec.onDisconnected(reconnectFut);
    }

    private int[] calculateQueryPartitions(CacheQueryPartitionInfo[] partInfoList, Object[] params) throws IgniteCheckedException {
        ArrayList<Integer> list = new ArrayList<Integer>(partInfoList.length);
        for (CacheQueryPartitionInfo partInfo : partInfoList) {
            int i;
            int partId = partInfo.partition() >= 0 ? partInfo.partition() : this.bindPartitionInfoParameter(partInfo, params);
            for (i = 0; i < list.size() && (Integer)list.get(i) < partId; ++i) {
            }
            if (i < list.size()) {
                if ((Integer)list.get(i) <= partId) continue;
                list.add(i, partId);
                continue;
            }
            list.add(partId);
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    private int bindPartitionInfoParameter(CacheQueryPartitionInfo partInfo, Object[] params) throws IgniteCheckedException {
        assert (partInfo != null);
        assert (partInfo.partition() < 0);
        GridH2RowDescriptor desc = this.dataTable(this.schema(partInfo.cacheName()), partInfo.tableName()).rowDescriptor();
        Object param = H2Utils.convert(params[partInfo.paramIdx()], desc, partInfo.dataType());
        return this.kernalContext().affinity().partition(partInfo.cacheName(), param);
    }

    public Collection<GridRunningQueryInfo> runningQueries(long duration) {
        ArrayList<GridRunningQueryInfo> res = new ArrayList<GridRunningQueryInfo>();
        res.addAll(this.runs.values());
        res.addAll(this.rdcQryExec.longRunningQueries(duration));
        return res;
    }

    public void cancelQueries(Collection<Long> queries) {
        if (!F.isEmpty(queries)) {
            for (Long qryId : queries) {
                GridRunningQueryInfo run = (GridRunningQueryInfo)this.runs.get(qryId);
                if (run == null) continue;
                run.cancel();
            }
            this.rdcQryExec.cancelQueries(queries);
        }
    }

    public void cancelAllQueries() {
        this.mapQryExec.cancelLazyWorkers();
        for (Connection conn : this.conns) {
            U.close((AutoCloseable)conn, (IgniteLogger)this.log);
        }
    }

    public List<Integer> collectCacheIds(@Nullable Integer mainCacheId, GridCacheTwoStepQuery twoStepQry) {
        LinkedHashSet<Integer> caches0 = new LinkedHashSet<Integer>();
        int tblCnt = twoStepQry.tablesCount();
        if (mainCacheId != null) {
            caches0.add(mainCacheId);
        }
        if (tblCnt > 0) {
            for (QueryTable tblKey : twoStepQry.tables()) {
                GridH2Table tbl = this.dataTable(tblKey);
                int cacheId = CU.cacheId((String)tbl.cacheName());
                caches0.add(cacheId);
            }
        }
        if (caches0.isEmpty()) {
            return null;
        }
        ArrayList<Integer> cacheIds = new ArrayList<Integer>(caches0);
        this.checkCacheIndexSegmentation(cacheIds);
        return cacheIds;
    }

    static {
        PageIO.registerH2(H2InnerIO.VERSIONS, H2LeafIO.VERSIONS);
        H2ExtrasInnerIO.register();
        H2ExtrasLeafIO.register();
        System.setProperty("h2.objectCache", "false");
        System.setProperty("h2.serializeJavaObject", "false");
        System.setProperty("h2.objectCacheMaxPerElementSize", "0");
        System.setProperty("h2.optimizeTwoEquals", "false");
        DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1;MAX_OPERATION_MEMORY=0;NESTED_JOINS=0;BATCH_JOINS=1;ROW_FACTORY=\"" + GridH2RowFactory.class.getName() + "\"" + ";DEFAULT_TABLE_ENGINE=" + GridH2DefaultTableEngine.class.getName();
        UPDATE_RESULT_META = Collections.singletonList(new H2SqlFieldMetadata(null, null, "UPDATED", Long.class.getName()));
    }

    private static interface ClIter<X>
    extends AutoCloseable,
    Iterator<X> {
    }
}

