/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.h2.result.SearchRow;

public class H2LeafIO
extends BPlusLeafIO<SearchRow>
implements H2RowLinkIO {
    public static final IOVersions<H2LeafIO> VERSIONS = new IOVersions((PageIO[])new H2LeafIO[]{new H2LeafIO(1)});

    protected H2LeafIO(int ver) {
        super(3, ver, 8);
    }

    public void storeByOffset(long pageAddr, int off, SearchRow row) {
        GridH2Row row0 = (GridH2Row)row;
        assert (row0.link != 0L);
        PageUtils.putLong((long)pageAddr, (int)off, (long)row0.link);
    }

    public void store(long dstPageAddr, int dstIdx, BPlusIO<SearchRow> srcIo, long srcPageAddr, int srcIdx) {
        assert (srcIo == this);
        PageUtils.putLong((long)dstPageAddr, (int)this.offset(dstIdx), (long)this.getLink(srcPageAddr, srcIdx));
    }

    public SearchRow getLookupRow(BPlusTree<SearchRow, ?> tree, long pageAddr, int idx) throws IgniteCheckedException {
        long link = this.getLink(pageAddr, idx);
        return ((H2Tree)tree).getRowFactory().getRow(link);
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        return PageUtils.getLong((long)pageAddr, (int)this.offset(idx));
    }
}

