/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.table.Column;
import org.h2.value.DataType;

public class DdlStatementsProcessor {
    GridKernalContext ctx;
    IgniteH2Indexing idx;

    public void start(GridKernalContext ctx, IgniteH2Indexing idx) {
        this.ctx = ctx;
        this.idx = idx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldsQueryCursor<List<?>> runDdlStatement(String sql, Prepared prepared) throws IgniteCheckedException {
        GridFinishedFuture fut = null;
        try {
            GridSqlStatement cmd;
            GridSqlStatement stmt0 = new GridSqlQueryParser(false).parse(prepared);
            if (stmt0 instanceof GridSqlCreateIndex) {
                cmd = (GridSqlCreateIndex)stmt0;
                GridH2Table tbl = this.idx.dataTable(((GridSqlCreateIndex)cmd).schemaName(), ((GridSqlCreateIndex)cmd).tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, ((GridSqlCreateIndex)cmd).tableName());
                }
                assert (tbl.rowDescriptor() != null);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(((GridSqlCreateIndex)cmd).index().getName());
                newIdx.setIndexType(((GridSqlCreateIndex)cmd).index().getIndexType());
                LinkedHashMap flds = new LinkedHashMap();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (Map.Entry e : ((GridSqlCreateIndex)cmd).index().getFields().entrySet()) {
                    GridQueryProperty prop = typeDesc.property((String)e.getKey());
                    if (prop == null) {
                        throw new SchemaOperationException(4, (String)e.getKey());
                    }
                    flds.put(prop.name(), e.getValue());
                }
                newIdx.setFields(flds);
                fut = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), ((GridSqlCreateIndex)cmd).schemaName(), typeDesc.tableName(), newIdx, ((GridSqlCreateIndex)cmd).ifNotExists());
            } else if (stmt0 instanceof GridSqlDropIndex) {
                cmd = (GridSqlDropIndex)stmt0;
                GridH2Table tbl = this.idx.dataTableForIndex(((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName());
                if (tbl != null) {
                    fut = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), ((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName(), ((GridSqlDropIndex)cmd).ifExists());
                } else {
                    if (!((GridSqlDropIndex)cmd).ifExists()) throw new SchemaOperationException(6, ((GridSqlDropIndex)cmd).indexName());
                    fut = new GridFinishedFuture();
                }
            } else if (stmt0 instanceof GridSqlCreateTable) {
                cmd = (GridSqlCreateTable)stmt0;
                if (!F.eq((Object)"PUBLIC", (Object)((GridSqlCreateTable)cmd).schemaName())) {
                    throw new SchemaOperationException("CREATE TABLE can only be executed on PUBLIC schema.");
                }
                GridH2Table tbl = this.idx.dataTable(((GridSqlCreateTable)cmd).schemaName(), ((GridSqlCreateTable)cmd).tableName());
                if (tbl != null) {
                    if (!((GridSqlCreateTable)cmd).ifNotExists()) {
                        throw new SchemaOperationException(3, ((GridSqlCreateTable)cmd).tableName());
                    }
                } else {
                    QueryEntity e = DdlStatementsProcessor.toQueryEntity((GridSqlCreateTable)cmd);
                    CacheConfiguration ccfg = new CacheConfiguration(((GridSqlCreateTable)cmd).tableName());
                    ccfg.setQueryEntities(Collections.singleton(e));
                    ccfg.setSqlSchema(((GridSqlCreateTable)cmd).schemaName());
                    SchemaOperationException err = QueryUtils.checkQueryEntityConflicts((CacheConfiguration)ccfg, this.ctx.cache().cacheDescriptors().values());
                    if (err != null) {
                        throw err;
                    }
                    this.ctx.query().dynamicTableCreate(((GridSqlCreateTable)cmd).schemaName(), e, ((GridSqlCreateTable)cmd).templateName(), ((GridSqlCreateTable)cmd).cacheName(), ((GridSqlCreateTable)cmd).cacheGroup(), ((GridSqlCreateTable)cmd).dataRegionName(), ((GridSqlCreateTable)cmd).affinityKey(), ((GridSqlCreateTable)cmd).atomicityMode(), ((GridSqlCreateTable)cmd).writeSynchronizationMode(), ((GridSqlCreateTable)cmd).backups(), ((GridSqlCreateTable)cmd).ifNotExists());
                }
            } else if (stmt0 instanceof GridSqlDropTable) {
                cmd = (GridSqlDropTable)stmt0;
                if (!F.eq((Object)"PUBLIC", (Object)((GridSqlDropTable)cmd).schemaName())) {
                    throw new SchemaOperationException("DROP TABLE can only be executed on PUBLIC schema.");
                }
                GridH2Table tbl = this.idx.dataTable(((GridSqlDropTable)cmd).schemaName(), ((GridSqlDropTable)cmd).tableName());
                if (tbl == null && ((GridSqlDropTable)cmd).ifExists()) {
                    this.ctx.cache().createMissingQueryCaches();
                    tbl = this.idx.dataTable(((GridSqlDropTable)cmd).schemaName(), ((GridSqlDropTable)cmd).tableName());
                }
                if (tbl == null) {
                    if (!((GridSqlDropTable)cmd).ifExists()) {
                        throw new SchemaOperationException(2, ((GridSqlDropTable)cmd).tableName());
                    }
                } else {
                    this.ctx.query().dynamicTableDrop(tbl.cacheName(), ((GridSqlDropTable)cmd).tableName(), ((GridSqlDropTable)cmd).ifExists());
                }
            } else {
                if (!(stmt0 instanceof GridSqlAlterTableAddColumn)) throw new IgniteSQLException("Unsupported DDL operation: " + sql, 1002);
                cmd = (GridSqlAlterTableAddColumn)stmt0;
                GridH2Table tbl = this.idx.dataTable(((GridSqlAlterTableAddColumn)cmd).schemaName(), ((GridSqlAlterTableAddColumn)cmd).tableName());
                if (tbl == null && ((GridSqlAlterTableAddColumn)cmd).ifTableExists()) {
                    this.ctx.cache().createMissingQueryCaches();
                    tbl = this.idx.dataTable(((GridSqlAlterTableAddColumn)cmd).schemaName(), ((GridSqlAlterTableAddColumn)cmd).tableName());
                }
                if (tbl == null) {
                    if (!((GridSqlAlterTableAddColumn)cmd).ifTableExists()) {
                        throw new SchemaOperationException(2, ((GridSqlAlterTableAddColumn)cmd).tableName());
                    }
                } else {
                    if (QueryUtils.isSqlType((Class)tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot add column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<QueryField> cols = new ArrayList<QueryField>(((GridSqlAlterTableAddColumn)cmd).columns().length);
                    boolean allFieldsNullable = true;
                    for (GridSqlColumn col : ((GridSqlAlterTableAddColumn)cmd).columns()) {
                        if (tbl.doesColumnExist(col.columnName())) {
                            if (!((GridSqlAlterTableAddColumn)cmd).ifNotExists() || ((GridSqlAlterTableAddColumn)cmd).columns().length != 1) {
                                throw new SchemaOperationException(5, col.columnName());
                            }
                            cols = null;
                            break;
                        }
                        QueryField field = new QueryField(col.columnName(), DataType.getTypeClassName((int)col.column().getType()), col.column().isNullable());
                        cols.add(field);
                        allFieldsNullable &= field.isNullable();
                    }
                    if (cols != null) {
                        assert (tbl.rowDescriptor() != null);
                        if (!allFieldsNullable) {
                            QueryUtils.checkNotNullAllowed((CacheConfiguration)tbl.cache().config());
                        }
                        fut = this.ctx.query().dynamicColumnAdd(tbl.cacheName(), ((GridSqlAlterTableAddColumn)cmd).schemaName(), tbl.rowDescriptor().type().tableName(), cols, ((GridSqlAlterTableAddColumn)cmd).ifTableExists(), ((GridSqlAlterTableAddColumn)cmd).ifNotExists());
                    }
                }
            }
            if (fut != null) {
                fut.get();
            }
            QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
            resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
            return resCur;
        }
        catch (SchemaOperationException e) {
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Unexpected DDL operation failure: " + e.getMessage(), (Throwable)e);
        }
    }

    private IgniteSQLException convert(SchemaOperationException e) {
        int sqlCode;
        switch (e.code()) {
            case 1: {
                sqlCode = 4006;
                break;
            }
            case 2: {
                sqlCode = 3001;
                break;
            }
            case 3: {
                sqlCode = 3007;
                break;
            }
            case 4: {
                sqlCode = 3008;
                break;
            }
            case 5: {
                sqlCode = 3009;
                break;
            }
            case 6: {
                sqlCode = 3006;
                break;
            }
            case 7: {
                sqlCode = 3005;
                break;
            }
            default: {
                sqlCode = 1;
            }
        }
        return new IgniteSQLException(e.getMessage(), sqlCode);
    }

    private static QueryEntity toQueryEntity(GridSqlCreateTable createTbl) {
        QueryEntity res = new QueryEntity();
        res.setTableName(createTbl.tableName());
        HashSet<String> notNullFields = null;
        for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
            GridSqlColumn gridCol = e.getValue();
            Column col = gridCol.column();
            res.addQueryField(e.getKey(), DataType.getTypeClassName((int)col.getType()), null);
            if (col.isNullable()) continue;
            if (notNullFields == null) {
                notNullFields = new HashSet<String>();
            }
            notNullFields.add(e.getKey());
        }
        String valTypeName = QueryUtils.createTableValueTypeName((String)createTbl.schemaName(), (String)createTbl.tableName());
        String keyTypeName = QueryUtils.createTableKeyTypeName((String)valTypeName);
        if (!F.isEmpty((String)createTbl.keyTypeName())) {
            keyTypeName = createTbl.keyTypeName();
        }
        if (!F.isEmpty((String)createTbl.valueTypeName())) {
            valTypeName = createTbl.valueTypeName();
        }
        assert (createTbl.wrapKey() != null);
        assert (createTbl.wrapValue() != null);
        if (!createTbl.wrapKey().booleanValue()) {
            GridSqlColumn pkCol = createTbl.columns().get(createTbl.primaryKeyColumns().iterator().next());
            keyTypeName = DataType.getTypeClassName((int)pkCol.column().getType());
            res.setKeyFieldName(pkCol.columnName());
        } else {
            res.setKeyFields(createTbl.primaryKeyColumns());
        }
        if (!createTbl.wrapValue().booleanValue()) {
            GridSqlColumn valCol = null;
            for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
                if (createTbl.primaryKeyColumns().contains(e.getKey())) continue;
                valCol = e.getValue();
                break;
            }
            valTypeName = DataType.getTypeClassName((int)valCol.column().getType());
            res.setValueFieldName(valCol.columnName());
        }
        res.setValueType(valTypeName);
        res.setKeyType(keyTypeName);
        if (!F.isEmpty(notNullFields)) {
            QueryEntityEx res0 = new QueryEntityEx(res);
            res0.setNotNullFields(notNullFields);
            res = res0;
        }
        return res;
    }

    public static boolean isDdlStatement(Prepared cmd) {
        return cmd instanceof CreateIndex || cmd instanceof DropIndex || cmd instanceof CreateTable || cmd instanceof DropTable || cmd instanceof AlterTableAlterColumn;
    }
}

