/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.dml.FastUpdateArguments;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuerySplitter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.table.Column;
import org.jetbrains.annotations.Nullable;

public final class UpdatePlanBuilder {
    private UpdatePlanBuilder() {
    }

    public static UpdatePlan planForStatement(Prepared prepared, boolean loc, IgniteH2Indexing idx, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQuery, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        assert (!prepared.isQuery());
        GridSqlStatement stmt = new GridSqlQueryParser(false).parse(prepared);
        if (stmt instanceof GridSqlMerge || stmt instanceof GridSqlInsert) {
            return UpdatePlanBuilder.planForInsert(stmt, loc, idx, conn, fieldsQuery);
        }
        return UpdatePlanBuilder.planForUpdate(stmt, loc, idx, conn, fieldsQuery, errKeysPos);
    }

    private static UpdatePlan planForInsert(GridSqlStatement stmt, boolean loc, IgniteH2Indexing idx, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQuery) throws IgniteCheckedException {
        UpdatePlan.DistributedPlanInfo distributed;
        int rowsNum;
        boolean isTwoStepSubqry;
        GridSqlQuery sel;
        GridSqlColumn[] cols;
        GridH2RowDescriptor desc;
        GridSqlTable tbl;
        GridSqlElement target;
        if (stmt instanceof GridSqlInsert) {
            GridSqlInsert ins = (GridSqlInsert)stmt;
            target = ins.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            cols = ins.columns();
            sel = DmlAstUtils.selectForInsertOrMerge(cols, ins.rows(), ins.query());
            isTwoStepSubqry = ins.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : ins.rows().size();
        } else if (stmt instanceof GridSqlMerge) {
            GridSqlMerge merge = (GridSqlMerge)stmt;
            target = merge.into();
            tbl = DmlAstUtils.gridTableForElement(target);
            desc = tbl.dataTable().rowDescriptor();
            cols = merge.columns();
            sel = DmlAstUtils.selectForInsertOrMerge(cols, merge.rows(), merge.query());
            isTwoStepSubqry = merge.query() != null;
            rowsNum = isTwoStepSubqry ? 0 : merge.rows().size();
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        isTwoStepSubqry = isTwoStepSubqry && (sel instanceof GridSqlUnion || sel instanceof GridSqlSelect && ((GridSqlSelect)sel).from() != null);
        int keyColIdx = -1;
        int valColIdx = -1;
        boolean hasKeyProps = false;
        boolean hasValProps = false;
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + tbl.dataTable().getName() + "'", 3002);
        }
        GridCacheContext<?, ?> cctx = desc.context();
        String[] colNames = new String[cols.length];
        int[] colTypes = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            String colName;
            GridSqlColumn col = cols[i];
            colNames[i] = colName = col.columnName();
            colTypes[i] = col.resultType().type();
            int colId = col.column().getColumnId();
            if (desc.isKeyColumn(colId)) {
                keyColIdx = i;
                continue;
            }
            if (desc.isValueColumn(colId)) {
                valColIdx = i;
                continue;
            }
            GridQueryProperty prop = desc.type().property(colName);
            assert (prop != null) : "Property '" + colName + "' not found.";
            if (prop.key()) {
                hasKeyProps = true;
                continue;
            }
            hasValProps = true;
        }
        KeyValueSupplier keySupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), keyColIdx, hasKeyProps, true, false);
        KeyValueSupplier valSupplier = UpdatePlanBuilder.createSupplier(cctx, desc.type(), valColIdx, hasValProps, false, false);
        String selectSql = sel.getSQL();
        UpdatePlan.DistributedPlanInfo distributedPlanInfo = distributed = rowsNum == 0 && !F.isEmpty((String)selectSql) ? UpdatePlanBuilder.checkPlanCanBeDistributed(idx, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName()) : null;
        if (stmt instanceof GridSqlMerge) {
            return UpdatePlan.forMerge(tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectSql, !isTwoStepSubqry, rowsNum, distributed);
        }
        return UpdatePlan.forInsert(tbl.dataTable(), colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectSql, !isTwoStepSubqry, rowsNum, distributed);
    }

    private static UpdatePlan planForUpdate(GridSqlStatement stmt, boolean loc, IgniteH2Indexing idx, @Nullable Connection conn, @Nullable SqlFieldsQuery fieldsQuery, @Nullable Integer errKeysPos) throws IgniteCheckedException {
        UpdateMode mode;
        FastUpdateArguments fastUpdate;
        GridSqlElement target;
        if (stmt instanceof GridSqlUpdate) {
            UpdatePlanBuilder.verifyUpdateColumns(stmt);
            GridSqlUpdate update = (GridSqlUpdate)stmt;
            target = update.target();
            fastUpdate = DmlAstUtils.getFastUpdateArgs(update);
            mode = UpdateMode.UPDATE;
        } else if (stmt instanceof GridSqlDelete) {
            GridSqlDelete del = (GridSqlDelete)stmt;
            target = del.from();
            fastUpdate = DmlAstUtils.getFastDeleteArgs(del);
            mode = UpdateMode.DELETE;
        } else {
            throw new IgniteSQLException("Unexpected DML operation [cls=" + stmt.getClass().getName() + ']', 2001);
        }
        GridSqlTable tbl = DmlAstUtils.gridTableForElement(target);
        GridH2Table gridTbl = tbl.dataTable();
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        if (desc == null) {
            throw new IgniteSQLException("Row descriptor undefined for table '" + gridTbl.getName() + "'", 3002);
        }
        if (fastUpdate != null) {
            return UpdatePlan.forFastUpdate(mode, gridTbl, fastUpdate);
        }
        if (stmt instanceof GridSqlUpdate) {
            boolean hasProps;
            ArrayList<GridSqlColumn> updatedCols = ((GridSqlUpdate)stmt).cols();
            int valColIdx = -1;
            String[] colNames = new String[updatedCols.size()];
            int[] colTypes = new int[updatedCols.size()];
            for (int i = 0; i < updatedCols.size(); ++i) {
                colNames[i] = ((GridSqlColumn)updatedCols.get(i)).columnName();
                colTypes[i] = ((GridSqlColumn)updatedCols.get(i)).resultType().type();
                Column col = ((GridSqlColumn)updatedCols.get(i)).column();
                if (!desc.isValueColumn(col.getColumnId())) continue;
                valColIdx = i;
            }
            boolean hasNewVal = valColIdx != -1;
            boolean bl = hasProps = !hasNewVal || updatedCols.size() > 1;
            if (hasNewVal) {
                valColIdx += 2;
            }
            int newValColIdx = hasNewVal ? valColIdx : 1;
            KeyValueSupplier newValSupplier = UpdatePlanBuilder.createSupplier(desc.context(), desc.type(), newValColIdx, hasProps, false, true);
            GridSqlSelect sel = DmlAstUtils.selectForUpdate((GridSqlUpdate)stmt, errKeysPos);
            String selectSql = sel.getSQL();
            UpdatePlan.DistributedPlanInfo distributed = F.isEmpty((String)selectSql) ? null : UpdatePlanBuilder.checkPlanCanBeDistributed(idx, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName());
            return UpdatePlan.forUpdate(gridTbl, colNames, colTypes, newValSupplier, valColIdx, selectSql, distributed);
        }
        GridSqlSelect sel = DmlAstUtils.selectForDelete((GridSqlDelete)stmt, errKeysPos);
        String selectSql = sel.getSQL();
        UpdatePlan.DistributedPlanInfo distributed = F.isEmpty((String)selectSql) ? null : UpdatePlanBuilder.checkPlanCanBeDistributed(idx, conn, fieldsQuery, loc, selectSql, tbl.dataTable().cacheName());
        return UpdatePlan.forDelete(gridTbl, selectSql, distributed);
    }

    private static KeyValueSupplier createSupplier(final GridCacheContext<?, ?> cctx, GridQueryTypeDescriptor desc, final int colIdx, boolean hasProps, final boolean key, boolean forUpdate) throws IgniteCheckedException {
        Constructor ctor;
        final String typeName = key ? desc.keyTypeName() : desc.valueTypeName();
        final Class cls = key ? (Class)U.firstNotNull((Object[])new Class[]{U.classForName((String)desc.keyTypeName(), null), desc.keyClass()}) : desc.valueClass();
        boolean isSqlType = QueryUtils.isSqlType((Class)cls);
        if (isSqlType || !hasProps) {
            if (colIdx != -1) {
                return new PlainValueSupplier(colIdx);
            }
            if (isSqlType) {
                throw new IgniteCheckedException((key ? "Key" : "Value") + " is missing from query");
            }
        }
        if (cctx.binaryMarshaller()) {
            if (colIdx != -1) {
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        Object obj = arg.get(colIdx);
                        if (obj == null) {
                            return null;
                        }
                        BinaryObject bin = (BinaryObject)cctx.grid().binary().toBinary(obj);
                        BinaryObjectBuilder builder = cctx.grid().binary().builder(bin);
                        cctx.prepareAffinityField(builder);
                        return builder;
                    }
                };
            }
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    BinaryObjectBuilder builder = cctx.grid().binary().builder(typeName);
                    cctx.prepareAffinityField(builder);
                    return builder;
                }
            };
        }
        if (colIdx != -1) {
            if (forUpdate && colIdx == 1) {
                assert (!key);
                return new KeyValueSupplier(){

                    public Object apply(List<?> arg) throws IgniteCheckedException {
                        byte[] oldPropBytes = cctx.marshaller().marshal(arg.get(1));
                        return cctx.marshaller().unmarshal(oldPropBytes, U.resolveClassLoader((IgniteConfiguration)cctx.gridConfig()));
                    }
                };
            }
            return new PlainValueSupplier(colIdx);
        }
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ignored) {
            ctor = null;
        }
        if (ctor != null) {
            final Constructor ctor0 = ctor;
            return new KeyValueSupplier(){

                public Object apply(List<?> arg) throws IgniteCheckedException {
                    try {
                        return ctor0.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        if (S.INCLUDE_SENSITIVE) {
                            throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                        }
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                    }
                }
            };
        }
        return new KeyValueSupplier(){

            public Object apply(List<?> arg) throws IgniteCheckedException {
                try {
                    return GridUnsafe.allocateInstance((Class)cls);
                }
                catch (InstantiationException e) {
                    if (S.INCLUDE_SENSITIVE) {
                        throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + " [type=" + typeName + ']', (Throwable)e);
                    }
                    throw new IgniteCheckedException("Failed to instantiate " + (key ? "key" : "value") + '.', (Throwable)e);
                }
            }
        };
    }

    private static void verifyUpdateColumns(GridSqlStatement statement) {
        if (statement == null || !(statement instanceof GridSqlUpdate)) {
            return;
        }
        GridSqlUpdate update = (GridSqlUpdate)statement;
        GridSqlElement updTarget = update.target();
        HashSet<GridSqlTable> tbls = new HashSet<GridSqlTable>();
        DmlAstUtils.collectAllGridTablesInTarget(updTarget, tbls);
        if (tbls.size() != 1) {
            throw new IgniteSQLException("Failed to determine target table for UPDATE", 3001);
        }
        GridSqlTable tbl = (GridSqlTable)tbls.iterator().next();
        GridH2Table gridTbl = tbl.dataTable();
        if (UpdatePlanBuilder.updateAffectsKeyColumns(gridTbl, update.set().keySet())) {
            throw new IgniteSQLException("SQL UPDATE can't modify key or its fields directly", 2003);
        }
    }

    private static boolean updateAffectsKeyColumns(GridH2Table gridTbl, Set<String> affectedColNames) {
        GridH2RowDescriptor desc = gridTbl.rowDescriptor();
        for (String colName : affectedColNames) {
            int colId = gridTbl.getColumn(colName).getColumnId();
            if (desc.isKeyColumn(colId)) {
                return true;
            }
            if (colId < 3 || !desc.isColumnKeyProperty(colId - 3)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UpdatePlan.DistributedPlanInfo checkPlanCanBeDistributed(IgniteH2Indexing idx, Connection conn, SqlFieldsQuery fieldsQry, boolean loc, String selectQry, String cacheName) throws IgniteCheckedException {
        if (loc) return null;
        if (!UpdatePlanBuilder.isSkipReducerOnUpdateQuery(fieldsQry)) {
            return null;
        }
        assert (conn != null);
        try (PreparedStatement stmt = conn.prepareStatement(selectQry);){
            idx.bindParameters(stmt, F.asList((Object[])fieldsQry.getArgs()));
            GridCacheTwoStepQuery qry = GridSqlQuerySplitter.split(conn, GridSqlQueryParser.prepared(stmt), fieldsQry.getArgs(), fieldsQry.isCollocated(), fieldsQry.isDistributedJoins(), fieldsQry.isEnforceJoinOrder(), idx);
            boolean distributed = qry.skipMergeTable() && qry.mapQueries().size() == 1 && !qry.mapQueries().get(0).hasSubQueries();
            UpdatePlan.DistributedPlanInfo distributedPlanInfo = distributed ? new UpdatePlan.DistributedPlanInfo(qry.isReplicatedOnly(), idx.collectCacheIds(CU.cacheId((String)cacheName), qry)) : null;
            return distributedPlanInfo;
        }
        catch (SQLException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public static boolean isSkipReducerOnUpdateQuery(SqlFieldsQuery qry) {
        return qry != null && !qry.isLocal() && qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isSkipReducerOnUpdate();
    }

    private static final class PlainValueSupplier
    implements KeyValueSupplier {
        private final int colIdx;

        private PlainValueSupplier(int colIdx) {
            this.colIdx = colIdx;
        }

        public Object apply(List<?> arg) throws IgniteCheckedException {
            return arg.get(this.colIdx);
        }
    }
}

