/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapRequestKey;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.ConcurrentLinkedHashMap;

class MapNodeResults {
    private final ConcurrentMap<MapRequestKey, MapQueryResults> res = new ConcurrentHashMap8();
    private final ConcurrentMap<Long, GridQueryCancel> updCancels = new ConcurrentHashMap8();
    private final GridBoundedConcurrentLinkedHashMap<Long, Boolean> qryHist = new GridBoundedConcurrentLinkedHashMap(1024, 1024, 0.75f, 64, ConcurrentLinkedHashMap.QueuePolicy.PER_SEGMENT_Q);
    private final UUID nodeId;

    public MapNodeResults(UUID nodeId) {
        this.nodeId = nodeId;
    }

    boolean cancelled(long reqId) {
        return this.qryHist.get((Object)reqId) != null;
    }

    boolean onCancel(long reqId) {
        Boolean old = (Boolean)this.qryHist.putIfAbsent((Object)reqId, (Object)Boolean.FALSE);
        return old == null;
    }

    public MapQueryResults get(long reqId, int segmentId) {
        return (MapQueryResults)this.res.get(new MapRequestKey(this.nodeId, reqId, segmentId));
    }

    public void cancelRequest(long reqId) {
        for (MapRequestKey key : this.res.keySet()) {
            MapQueryResults removed;
            if (key.requestId() != reqId || (removed = (MapQueryResults)this.res.remove(key)) == null) continue;
            removed.cancel(true);
        }
        GridQueryCancel updCancel = (GridQueryCancel)this.updCancels.remove(reqId);
        if (updCancel != null) {
            updCancel.cancel();
        }
    }

    public boolean remove(long reqId, int segmentId, MapQueryResults qr) {
        return this.res.remove(new MapRequestKey(this.nodeId, reqId, segmentId), qr);
    }

    public MapQueryResults put(long reqId, int segmentId, MapQueryResults qr) {
        return this.res.put(new MapRequestKey(this.nodeId, reqId, segmentId), qr);
    }

    public GridQueryCancel putUpdate(long reqId) {
        GridQueryCancel cancel = new GridQueryCancel();
        this.updCancels.put(reqId, cancel);
        return cancel;
    }

    public void removeUpdate(long reqId) {
        this.updCancels.remove(reqId);
    }

    public void cancelAll() {
        for (MapQueryResults ress : this.res.values()) {
            ress.cancel(true);
        }
        for (GridQueryCancel upd : this.updCancels.values()) {
            upd.cancel();
        }
    }
}

