/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.Iter;

public class IteratorTruncate<T>
implements Iterator<T> {
    private Test test;
    private T slot = null;
    private boolean active = true;
    private Iterator<T> iter;

    public IteratorTruncate(Test test, Iterator<T> iter) {
        this.test = test;
        this.iter = iter;
    }

    @Override
    public boolean hasNext() {
        if (!this.active) {
            return false;
        }
        if (this.slot != null) {
            return true;
        }
        if (!this.iter.hasNext()) {
            this.active = false;
            return false;
        }
        this.slot = this.iter.next();
        if (this.test.accept(this.slot)) {
            return true;
        }
        Iter.close(this.iter);
        this.active = false;
        this.iter = null;
        this.slot = null;
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("IteratorTruncate.next");
        }
        T x = this.slot;
        this.slot = null;
        return x;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("IteratorTruncate.remove");
    }

    public void close() {
        if (this.iter != null) {
            Iter.close(this.iter);
        }
    }

    public static interface Test {
        public boolean accept(Object var1);
    }
}

