/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.OutputUtils;

public class EscapeStr {
    public static String stringEsc(String s) {
        return EscapeStr.stringEsc(s, true, false);
    }

    private static String stringEsc(String s, boolean singleLineString, boolean asciiOnly) {
        IndentedLineBuffer sb = new IndentedLineBuffer();
        EscapeStr.stringEsc(sb, s, singleLineString, asciiOnly);
        return sb.toString();
    }

    public static void stringEsc(AWriter out, String s, boolean singleLineString, boolean asciiOnly) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                out.print('\\');
                out.print(c);
                continue;
            }
            if (singleLineString) {
                if (c == '\"') {
                    out.print("\\\"");
                    continue;
                }
                if (c == '\n') {
                    out.print("\\n");
                    continue;
                }
                if (c == '\t') {
                    out.print("\\t");
                    continue;
                }
                if (c == '\r') {
                    out.print("\\r");
                    continue;
                }
                if (c == '\f') {
                    out.print("\\f");
                    continue;
                }
            }
            if (c >= ' ' && c < '\u007f') {
                out.print(c);
                continue;
            }
            if (!asciiOnly) {
                out.print(c);
                continue;
            }
            out.print("\\u");
            OutputUtils.printHex(out, (int)c, 4);
        }
    }

    public static String unescapeStr(String s) {
        return EscapeStr.unescapeStr(s, '\\');
    }

    public static String unescapeStr(String s, char escapeChar) {
        return EscapeStr.unescape(s, escapeChar, false);
    }

    public static String unescape(String s, char escape, boolean pointCodeOnly) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    throw new AtlasException("Illegal escape at end of string");
                }
                char ch2 = s.charAt(i + 1);
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new AtlasException("\\u escape too short");
                    }
                    x = EscapeStr.hex(s, i + 1, 4);
                    sb.append((char)x);
                    i += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        throw new AtlasException("\\U escape too short");
                    }
                    x = EscapeStr.hex(s, i + 1, 8);
                    sb.append((char)x);
                    i += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new AtlasException("Unknown escape: \\" + ch2);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static int hex(String s, int i, int len) {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new AtlasException("Illegal hex escape: " + ch);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }
}

