/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OAuthBearerLoginModuleTest {
    @Test
    public void login1Commit1Login2Commit2Logout1Login3Commit3Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class)};
        EasyMock.replay((Object[])new Object[]{tokens[0], tokens[1], tokens[2]});
        TestTokenCallbackHandler testTokenCallbackHandler = new TestTokenCallbackHandler(tokens);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Assert.assertNotSame((Object)tokens[2], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[2], (Object)iterator.next());
        loginModule1.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        loginModule3.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        loginModule3.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        iterator = privateCredentials.iterator();
        Assert.assertNotSame((Object)tokens[0], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[0], (Object)iterator.next());
        loginModule2.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
    }

    @Test
    public void login1Commit1Logout1Login2Commit2Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class)};
        EasyMock.replay((Object[])new Object[]{tokens[0], tokens[1]});
        TestTokenCallbackHandler testTokenCallbackHandler = new TestTokenCallbackHandler(tokens);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule1.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule2.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule2.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        loginModule2.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
    }

    @Test
    public void loginAbortLoginCommitLogout() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class)};
        EasyMock.replay((Object[])new Object[]{tokens[0], tokens[1]});
        TestTokenCallbackHandler testTokenCallbackHandler = new TestTokenCallbackHandler(tokens);
        OAuthBearerLoginModule loginModule = new OAuthBearerLoginModule();
        loginModule.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule.abort();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        loginModule.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
    }

    @Test
    public void login1Commit1Login2Abort2Login3Commit3Logout3() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class), (OAuthBearerToken)EasyMock.mock(OAuthBearerToken.class)};
        EasyMock.replay((Object[])new Object[]{tokens[0], tokens[1], tokens[2]});
        TestTokenCallbackHandler testTokenCallbackHandler = new TestTokenCallbackHandler(tokens);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.abort();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        loginModule2.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Assert.assertNotSame((Object)tokens[1], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[1], (Object)iterator.next());
        loginModule1.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
    }

    private static class TestTokenCallbackHandler
    implements AuthenticateCallbackHandler {
        private final OAuthBearerToken[] tokens;
        private int index = 0;

        public TestTokenCallbackHandler(OAuthBearerToken[] tokens) {
            this.tokens = Objects.requireNonNull(tokens);
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof OAuthBearerTokenCallback) {
                    try {
                        this.handleCallback((OAuthBearerTokenCallback)callback);
                        continue;
                    }
                    catch (KafkaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                throw new UnsupportedCallbackException(callback);
            }
        }

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        }

        public void close() {
        }

        private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
            if (callback.token() != null) {
                throw new IllegalArgumentException("Callback had a token already");
            }
            if (this.tokens.length <= this.index) {
                throw new IOException("no more tokens");
            }
            callback.token(this.tokens[this.index++]);
        }
    }
}

