/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.Map;
import org.apache.maven.surefire.junitcore.ClassesParallelRunListener;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.MethodsParallelRunListener;
import org.apache.maven.surefire.junitcore.TestMethod;
import org.apache.maven.surefire.junitcore.TestSet;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.testset.TestSetFailedException;

public abstract class ConcurrentRunListener
implements RunListener,
ConsoleOutputReceiver {
    private final Map<String, TestSet> classMethodCounts;
    private final ThreadLocal<RunListener> reporterManagerThreadLocal;
    private final boolean reportImmediately;
    private final ConsoleStream consoleStream;

    ConcurrentRunListener(final ReporterFactory reporterFactory, ConsoleStream consoleStream, boolean reportImmediately, Map<String, TestSet> classMethodCounts) throws TestSetFailedException {
        this.reportImmediately = reportImmediately;
        this.classMethodCounts = classMethodCounts;
        this.consoleStream = consoleStream;
        this.reporterManagerThreadLocal = new ThreadLocal<RunListener>(){

            @Override
            protected RunListener initialValue() {
                return reporterFactory.createReporter();
            }
        };
    }

    public void testSetStarting(ReportEntry description) {
    }

    public void testSetCompleted(ReportEntry result) {
        RunListener reporterManager = this.getRunListener();
        for (TestSet testSet : this.classMethodCounts.values()) {
            testSet.replay(reporterManager);
        }
        this.reporterManagerThreadLocal.remove();
    }

    public void testFailed(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testFailure(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testError(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testError(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testSkipped(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        TestMethod testMethod = testSet.createThreadAttachedTestMethod(description);
        testMethod.testIgnored(description);
        testSet.incrementFinishedTests(this.getRunListener(), this.reportImmediately);
        testMethod.detachFromCurrentThread();
    }

    public void testExecutionSkippedByUser() {
        this.reporterManagerThreadLocal.get().testExecutionSkippedByUser();
    }

    public void testAssumptionFailure(ReportEntry failure) {
        TestMethod testMethod = this.getOrCreateThreadAttachedTestMethod(failure);
        if (testMethod != null) {
            testMethod.testIgnored(failure);
            testMethod.detachFromCurrentThread();
        }
    }

    public void testStarting(ReportEntry description) {
        TestSet testSet = this.getTestSet(description);
        testSet.createThreadAttachedTestMethod(description);
        this.checkIfTestSetCanBeReported(testSet);
        testSet.attachToThread();
    }

    public void testSucceeded(ReportEntry report) {
        TestMethod testMethod = TestMethod.getThreadTestMethod();
        if (testMethod != null) {
            testMethod.testFinished();
            testMethod.getTestSet().incrementFinishedTests(this.getRunListener(), this.reportImmediately);
            testMethod.detachFromCurrentThread();
        }
    }

    private TestMethod getOrCreateThreadAttachedTestMethod(ReportEntry description) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            return threadTestMethod;
        }
        TestSet testSet = this.getTestSet(description);
        if (testSet == null) {
            this.consoleStream.println(description.getName());
            StackTraceWriter writer = description.getStackTraceWriter();
            if (writer != null) {
                this.consoleStream.println(writer.writeTraceToString());
            }
            return null;
        }
        return testSet.createThreadAttachedTestMethod(description);
    }

    protected abstract void checkIfTestSetCanBeReported(TestSet var1);

    TestSet getTestSet(ReportEntry description) {
        return this.classMethodCounts.get(description.getSourceName());
    }

    RunListener getRunListener() {
        return this.reporterManagerThreadLocal.get();
    }

    public static ConcurrentRunListener createInstance(Map<String, TestSet> classMethodCounts, ReporterFactory reporterFactory, boolean parallelClasses, boolean parallelBoth, ConsoleStream consoleStream) throws TestSetFailedException {
        return parallelClasses ? new ClassesParallelRunListener(classMethodCounts, reporterFactory, consoleStream) : new MethodsParallelRunListener(classMethodCounts, reporterFactory, !parallelBoth, consoleStream);
    }

    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        TestMethod threadTestMethod = TestMethod.getThreadTestMethod();
        if (threadTestMethod != null) {
            LogicalStream logicalStream = threadTestMethod.getLogicalStream();
            logicalStream.write(stdout, buf, off, len);
        } else {
            this.consoleStream.println(buf, off, len);
        }
    }
}

