/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.h263;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.BitReaderBuffer;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderConfigDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.DecoderSpecificInfo;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.ESDescriptor;
import org.mp4parser.boxes.iso14496.part1.objectdescriptors.SLConfigDescriptor;
import org.mp4parser.boxes.iso14496.part14.ESDescriptorBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.SampleImpl;
import org.mp4parser.muxer.tracks.AbstractH26XTrack;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.Mp4Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H263TrackImpl
extends AbstractH26XTrack {
    private static Logger LOG = LoggerFactory.getLogger((String)ESDescriptor.class.getName());
    private int RECTANGULAR = 0;
    private int BINARY = 1;
    private int BINARY_ONLY = 2;
    private int GRAYSCALE = 3;
    private List<Sample> samples = new ArrayList<Sample>();
    private List<ByteBuffer> esdsStuff = new ArrayList<ByteBuffer>();
    private boolean esdsComplete = false;
    private int fixed_vop_time_increment = -1;
    private int vop_time_increment_resolution = 0;
    private VisualSampleEntry mp4v;

    public H263TrackImpl(DataSource dataSource) throws IOException {
        super(dataSource, false);
        ByteBuffer nal;
        AbstractH26XTrack.LookAhead la = new AbstractH26XTrack.LookAhead(dataSource);
        ArrayList<ByteBuffer> nalsInSample = new ArrayList<ByteBuffer>();
        int visual_object_verid = 0;
        this.mp4v = new VisualSampleEntry("mp4v");
        long last_sync_point = 0L;
        long last_time_code = -1L;
        while ((nal = this.findNextNal(la)) != null) {
            ByteBuffer origNal = nal.duplicate();
            int type = IsoTypeReader.readUInt8((ByteBuffer)nal);
            if (type == 176 || type == 181 || type == 0 || type == 32 || type == 178) {
                if (this.esdsComplete) continue;
                this.esdsStuff.add(origNal);
                if (type == 32) {
                    this.parse0x20Unit(nal, visual_object_verid, this.mp4v);
                    continue;
                }
                if (type != 181) continue;
                visual_object_verid = this.parse0x05Unit(nal);
                continue;
            }
            if (type == 179) {
                this.esdsComplete = true;
                BitReaderBuffer bitReaderBuffer = new BitReaderBuffer(nal);
                int time_code = bitReaderBuffer.readBits(18);
                last_sync_point = (time_code & 0x3F) + (time_code >>> 7 & 0x3F) * 60 + (time_code >>> 13 & 0x1F) * 60 * 60;
                this.stss.add(this.samples.size() + 1);
                nalsInSample.add(origNal);
                continue;
            }
            if (type == 182) {
                BitReaderBuffer brb = new BitReaderBuffer(nal);
                int vop_coding_type = brb.readBits(2);
                while (brb.readBool()) {
                    ++last_sync_point;
                }
                boolean marker_bit = brb.readBool();
                int i = 0;
                while (this.vop_time_increment_resolution >= 1 << i) {
                    ++i;
                }
                int vop_time_increment = brb.readBits(i);
                long time_code = last_sync_point * (long)this.vop_time_increment_resolution + (long)(vop_time_increment % this.vop_time_increment_resolution);
                if (last_time_code != -1L) {
                    this.decodingTimes = Mp4Arrays.copyOfAndAppend((long[])this.decodingTimes, (long[])new long[]{time_code - last_time_code});
                }
                System.err.println("Frame increment: " + (time_code - last_time_code) + " vop time increment: " + vop_time_increment + " last_sync_point: " + last_sync_point + " time_code: " + time_code);
                last_time_code = time_code;
                nalsInSample.add(origNal);
                this.samples.add(this.createSampleObject(nalsInSample));
                nalsInSample.clear();
                continue;
            }
            throw new RuntimeException("Got start code I don't know. Ask Sebastian via mp4parser mailing list what to do");
        }
        this.decodingTimes = Mp4Arrays.copyOfAndAppend((long[])this.decodingTimes, (long[])new long[]{this.decodingTimes[this.decodingTimes.length - 1]});
        ESDescriptor esDescriptor = new ESDescriptor();
        esDescriptor.setEsId(1);
        DecoderConfigDescriptor decoderConfigDescriptor = new DecoderConfigDescriptor();
        decoderConfigDescriptor.setObjectTypeIndication(32);
        decoderConfigDescriptor.setStreamType(4);
        DecoderSpecificInfo decoderSpecificInfo = new DecoderSpecificInfo();
        Sample s = this.createSampleObject(this.esdsStuff);
        byte[] data = new byte[CastUtils.l2i((long)s.getSize())];
        s.asByteBuffer().get(data);
        decoderSpecificInfo.setData(data);
        decoderConfigDescriptor.setDecoderSpecificInfo(decoderSpecificInfo);
        esDescriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
        SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
        slConfigDescriptor.setPredefined(2);
        esDescriptor.setSlConfigDescriptor(slConfigDescriptor);
        ESDescriptorBox esds = new ESDescriptorBox();
        esds.setEsDescriptor(esDescriptor);
        this.mp4v.addBox((Box)esds);
        this.trackMetaData.setTimescale(this.vop_time_increment_resolution);
    }

    @Override
    protected SampleEntry getCurrentSampleEntry() {
        return null;
    }

    private int parse0x05Unit(ByteBuffer nal) {
        int visual_object_verid = 0;
        BitReaderBuffer brb = new BitReaderBuffer(nal);
        boolean is_visual_object_identifier = brb.readBool();
        if (is_visual_object_identifier) {
            visual_object_verid = brb.readBits(4);
            int n = brb.readBits(3);
        }
        return visual_object_verid;
    }

    private void parse0x20Unit(ByteBuffer nal, int visual_object_verid, VisualSampleEntry mp4v) {
        int video_object_layer_shape;
        int low_delay;
        boolean vol_control_parameters;
        int aspect_ratio_info;
        BitReaderBuffer brb = new BitReaderBuffer(nal);
        boolean random_accessible_vol = brb.readBool();
        int video_object_type_indication = brb.readBits(8);
        boolean is_object_layer_identifier = brb.readBool();
        int video_object_layer_verid = visual_object_verid;
        if (is_object_layer_identifier) {
            video_object_layer_verid = brb.readBits(4);
            int n = brb.readBits(3);
        }
        if ((aspect_ratio_info = brb.readBits(4)) == 15) {
            int par_width = brb.readBits(8);
            int n = brb.readBits(8);
        }
        if (vol_control_parameters = brb.readBool()) {
            int chroma_format = brb.readBits(2);
            low_delay = brb.readBool();
            boolean vbv_parameters = brb.readBool();
            if (vbv_parameters) {
                throw new RuntimeException("Implemented when needed");
            }
        }
        if ((video_object_layer_shape = brb.readBits(2)) == this.GRAYSCALE && video_object_layer_verid != 1) {
            low_delay = brb.readBits(4);
        }
        boolean marker_bit = brb.readBool();
        this.vop_time_increment_resolution = brb.readBits(16);
        marker_bit = brb.readBool();
        boolean fixed_vop_rate = brb.readBool();
        if (fixed_vop_rate) {
            LOG.info("Fixed Frame Rate");
            int i = 0;
            while (this.vop_time_increment_resolution >= 1 << i) {
                ++i;
            }
            this.fixed_vop_time_increment = brb.readBits(i);
        }
        if (video_object_layer_shape != this.BINARY_ONLY) {
            if (video_object_layer_shape == this.RECTANGULAR) {
                brb.readBool();
                int video_object_layer_width = brb.readBits(13);
                mp4v.setWidth(video_object_layer_width);
                brb.readBool();
                int video_object_layer_height = brb.readBits(13);
                mp4v.setHeight(video_object_layer_height);
                brb.readBool();
            }
        } else {
            throw new RuntimeException("Please implmenet me");
        }
    }

    @Override
    protected Sample createSampleObject(List<? extends ByteBuffer> nals) {
        ByteBuffer startcode = ByteBuffer.wrap(new byte[]{0, 0, 1});
        ByteBuffer[] data = new ByteBuffer[nals.size() * 2];
        for (int i = 0; i < nals.size(); ++i) {
            data[2 * i] = startcode;
            data[2 * i + 1] = nals.get(i);
        }
        return new SampleImpl(data, (SampleEntry)this.mp4v);
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.mp4v);
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }
}

