/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.DataConversion;
import org.mvel2.ErrorDetail;
import org.mvel2.MVEL;
import org.mvel2.Operator;
import org.mvel2.ParserContext;
import org.mvel2.ast.ASTNode;
import org.mvel2.ast.Assignment;
import org.mvel2.ast.LiteralNode;
import org.mvel2.ast.NewObjectNode;
import org.mvel2.ast.OperatorNode;
import org.mvel2.ast.Substatement;
import org.mvel2.ast.Union;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.compiler.PropertyVerifier;
import org.mvel2.util.ASTLinkedList;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.ErrorUtil;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;
import org.mvel2.util.StringAppender;

public class ExpressionCompiler
extends AbstractParser {
    private Class returnType;
    private boolean verifyOnly = false;
    private boolean verifying = true;
    private boolean secondPassOptimization = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledExpression compile() {
        try {
            this.debugSymbols = this.pCtx.isDebugSymbols();
            CompiledExpression compiledExpression = this._compile();
            return compiledExpression;
        }
        finally {
            if (this.pCtx.isFatalError()) {
                StringAppender err = new StringAppender();
                Iterator<ErrorDetail> iter = this.pCtx.getErrorList().iterator();
                while (iter.hasNext()) {
                    ErrorDetail e = iter.next();
                    if ((e = ErrorUtil.rewriteIfNeeded(e, this.expr, this.cursor)).getExpr() != this.expr) {
                        iter.remove();
                        continue;
                    }
                    err.append("\n - ").append("(").append(e.getLineNumber()).append(",").append(e.getColumn()).append(")").append(" ").append(e.getMessage());
                }
                throw new CompileException("Failed to compileShared: " + this.pCtx.getErrorList().size() + " compilation error(s): " + err.toString(), this.pCtx.getErrorList(), this.expr, this.cursor, this.pCtx);
            }
        }
    }

    public CompiledExpression _compile() {
        int lastOp = -1;
        this.cursor = this.start;
        ASTLinkedList astBuild = new ASTLinkedList();
        this.stk = new ExecutionStack();
        this.dStack = new ExecutionStack();
        this.compileMode = true;
        try {
            ASTNode tk;
            if (this.verifying) {
                this.pCtx.initializeTables();
            }
            this.fields |= 0x10;
            block8: while ((tk = this.nextToken()) != null) {
                if (tk.fields == -1) {
                    astBuild.addTokenNode(tk);
                    continue;
                }
                this.returnType = tk.getEgressType();
                if (tk instanceof Substatement) {
                    String key = new String(this.expr, tk.getStart(), tk.getOffset());
                    Map<String, CompiledExpression> cec = this.pCtx.getCompiledExpressionCache();
                    Map<String, Class> rtc = this.pCtx.getReturnTypeCache();
                    CompiledExpression compiled = cec.get(key);
                    Class rt = rtc.get(key);
                    if (compiled == null) {
                        ExpressionCompiler subCompiler = new ExpressionCompiler(this.expr, tk.getStart(), tk.getOffset(), this.pCtx);
                        compiled = subCompiler._compile();
                        rt = subCompiler.getReturnType();
                        cec.put(key, compiled);
                        rtc.put(key, rt);
                    }
                    tk.setAccessor(compiled);
                    this.returnType = rt;
                }
                if (!this.verifyOnly && tk.isLiteral()) {
                    ASTNode tkOp;
                    if (this.literalOnly == -1) {
                        this.literalOnly = 1;
                    }
                    if ((tkOp = this.nextTokenSkipSymbols()) != null && tkOp.isOperator() && !tkOp.isOperator(29) && !tkOp.isOperator(30)) {
                        ASTNode tkLA = this.nextTokenSkipSymbols();
                        if (tkLA != null && tkLA.isLiteral() && tkOp.getOperator() < 34 && (lastOp == -1 || lastOp < Operator.PTABLE.length && Operator.PTABLE[lastOp] < Operator.PTABLE[tkOp.getOperator()])) {
                            ASTNode tkOp2;
                            int op = tkOp.getOperator();
                            this.stk.push(tk.getLiteralValue(), tkLA.getLiteralValue(), op);
                            if (ExpressionCompiler.isArithmeticOperator(op)) {
                                if (!this.compileReduce(op, astBuild)) {
                                    continue;
                                }
                            } else {
                                this.reduce();
                            }
                            boolean firstLA = true;
                            while ((tkOp2 = this.nextTokenSkipSymbols()) != null) {
                                if (ExpressionCompiler.isBooleanOperator(tkOp2.getOperator())) {
                                    astBuild.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx), this.verify(this.pCtx, tkOp2));
                                    break;
                                }
                                ASTNode tkLA2 = this.nextTokenSkipSymbols();
                                if (tkLA2 != null) {
                                    if (tkLA2.isLiteral()) {
                                        op = tkOp2.getOperator();
                                        this.stk.push(tkLA2.getLiteralValue(), op);
                                        if (ExpressionCompiler.isArithmeticOperator(op)) {
                                            if (!this.compileReduce(op, astBuild)) {
                                                continue block8;
                                            }
                                        } else {
                                            this.reduce();
                                        }
                                    } else {
                                        if (!this.stk.isEmpty()) {
                                            astBuild.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                                        }
                                        astBuild.addTokenNode(new OperatorNode(tkOp2.getOperator(), this.expr, this.st, this.pCtx), this.verify(this.pCtx, tkLA2));
                                        break;
                                    }
                                    firstLA = false;
                                    this.literalOnly = 0;
                                    continue;
                                }
                                if (firstLA) {
                                    astBuild.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                                    break;
                                }
                                astBuild.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx), tkOp2);
                                if (tkLA2 == null) break;
                                astBuild.addTokenNode(this.verify(this.pCtx, tkLA2));
                                break;
                            }
                            if (this.stk.isEmpty()) continue;
                            astBuild.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                            continue;
                        }
                        astBuild.addTokenNode(this.verify(this.pCtx, tk), this.verify(this.pCtx, tkOp));
                        if (tkLA == null) continue;
                        astBuild.addTokenNode(this.verify(this.pCtx, tkLA));
                        continue;
                    }
                    if (tkOp != null && !tkOp.isOperator() && !(tk.getLiteralValue() instanceof Class)) {
                        throw new CompileException("unexpected token: " + tkOp.getName(), this.expr, tkOp.getStart());
                    }
                    this.literalOnly = 0;
                    astBuild.addTokenNode(this.verify(this.pCtx, tk));
                    if (tkOp == null) continue;
                    astBuild.addTokenNode(this.verify(this.pCtx, tkOp));
                    continue;
                }
                if (tk.isOperator()) {
                    lastOp = tk.getOperator();
                } else {
                    this.literalOnly = 0;
                }
                astBuild.addTokenNode(this.verify(this.pCtx, tk));
            }
            astBuild.finish();
            if (this.verifying && !this.verifyOnly) {
                this.pCtx.processTables();
            }
            if (!this.stk.isEmpty()) {
                throw new CompileException("COMPILE ERROR: non-empty stack after compileShared.", this.expr, this.cursor);
            }
            if (!this.verifyOnly) {
                try {
                    return new CompiledExpression(CompilerTools.finalizePayload(astBuild, this.secondPassOptimization, this.pCtx), this.pCtx.getSourceFile(), this.returnType, this.pCtx.getParserConfiguration(), this.literalOnly == 1);
                }
                catch (RuntimeException e) {
                    throw new CompileException(e.getMessage(), this.expr, this.st, e);
                }
            }
            try {
                this.returnType = CompilerTools.getReturnType(astBuild, this.pCtx.isStrongTyping());
            }
            catch (RuntimeException e) {
                throw new CompileException(e.getMessage(), this.expr, this.st, e);
            }
            return null;
        }
        catch (NullPointerException e) {
            throw new CompileException("not a statement, or badly formed structure", this.expr, this.st, e);
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.st);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CompileException(e.getMessage(), this.expr, this.st, e);
        }
    }

    private Object getStackValueResult() {
        return (this.fields & 0x80000) == 0 ? this.stk.pop() : CompilerTools.signNumber(this.stk.pop());
    }

    private boolean compileReduce(int opCode, ASTLinkedList astBuild) {
        switch (this.arithmeticFunctionReduction(opCode)) {
            case -1: {
                this.stk.xswap_op();
                astBuild.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx));
                astBuild.addTokenNode((OperatorNode)this.splitAccumulator.pop(), this.verify(this.pCtx, (ASTNode)this.splitAccumulator.pop()));
                return false;
            }
            case -2: {
                LiteralNode rightValue = new LiteralNode(this.stk.pop(), this.pCtx);
                OperatorNode operator = new OperatorNode((Integer)this.stk.pop(), this.expr, this.st, this.pCtx);
                astBuild.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx), operator);
                astBuild.addTokenNode(rightValue, (OperatorNode)this.splitAccumulator.pop());
                astBuild.addTokenNode(this.verify(this.pCtx, (ASTNode)this.splitAccumulator.pop()));
                return false;
            }
            case -3: {
                ASTNode tkLA2 = (ASTNode)this.stk.pop();
                Integer tkOp2 = (Integer)this.stk.pop();
                astBuild.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                astBuild.addTokenNode(new OperatorNode(tkOp2, this.expr, this.st, this.pCtx), this.verify(this.pCtx, tkLA2));
                return false;
            }
        }
        return true;
    }

    private static boolean isBooleanOperator(int operator) {
        return operator == 21 || operator == 22 || operator == 29 || operator == 30;
    }

    protected ASTNode verify(ParserContext pCtx, ASTNode tk) {
        if (tk.isOperator() && (tk.getOperator().equals(21) || tk.getOperator().equals(22))) {
            this.secondPassOptimization = true;
        }
        if (tk.isDiscard() || tk.isOperator()) {
            return tk;
        }
        if (tk.isLiteral()) {
            if ((this.fields & 0x10) != 0 && tk.getClass() == ASTNode.class) {
                return new LiteralNode(tk.getLiteralValue(), pCtx);
            }
            return tk;
        }
        if (this.verifying) {
            if (tk.isIdentifier()) {
                PropertyVerifier propVerifier = new PropertyVerifier(this.expr, tk.getStart(), tk.getOffset(), pCtx);
                if (tk instanceof Union) {
                    propVerifier.setCtx(((Union)tk).getLeftEgressType());
                    this.returnType = propVerifier.analyze();
                    tk.setEgressType(this.returnType);
                } else {
                    this.returnType = propVerifier.analyze();
                    tk.setEgressType(this.returnType);
                    if (propVerifier.isFqcn()) {
                        tk.setAsFQCNReference();
                    }
                    if (propVerifier.isClassLiteral()) {
                        return new LiteralNode(this.returnType, pCtx);
                    }
                    if (propVerifier.isInput()) {
                        pCtx.addInput(tk.getAbsoluteName(), propVerifier.isDeepProperty() ? Object.class : this.returnType);
                    }
                    if (!(propVerifier.isMethodCall() || this.returnType.isEnum() || pCtx.isOptimizerNotified() || !pCtx.isStrongTyping() || pCtx.isVariableVisible(tk.getAbsoluteName()) || tk.isFQCN())) {
                        throw new CompileException("no such identifier: " + tk.getAbsoluteName(), this.expr, tk.getStart());
                    }
                }
            } else if (tk.isAssignment()) {
                Assignment a = (Assignment)((Object)tk);
                if (a.getAssignmentVar() != null) {
                    PropertyVerifier propVerifier = new PropertyVerifier(a.getAssignmentVar(), pCtx);
                    this.returnType = propVerifier.analyze();
                    tk.setEgressType(this.returnType);
                    if (!a.isNewDeclaration() && propVerifier.isResolvedExternally()) {
                        pCtx.addInput(tk.getAbsoluteName(), this.returnType);
                    }
                    ExecutableStatement c = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, tk.getStart(), tk.getOffset(), pCtx);
                    if (pCtx.isStrictTypeEnforcement() && !this.returnType.isAssignableFrom(c.getKnownEgressType()) && c.isLiteralOnly()) {
                        if (DataConversion.canConvert(c.getKnownEgressType(), this.returnType)) {
                            try {
                                a.setValueStatement(new ExecutableLiteral(DataConversion.convert(c.getValue(null, null), this.returnType)));
                                return tk;
                            }
                            catch (Exception e) {}
                        } else if (this.returnType.isPrimitive() && ParseTools.unboxPrimitive(c.getKnownEgressType()).equals(this.returnType)) {
                            return tk;
                        }
                        throw new CompileException("cannot assign type " + c.getKnownEgressType().getName() + " to " + this.returnType.getName(), this.expr, this.st);
                    }
                }
            } else if (tk instanceof NewObjectNode) {
                NewObjectNode n = (NewObjectNode)tk;
                List<char[]> parms = ParseTools.parseMethodOrConstructor(tk.getNameAsArray());
                if (parms != null) {
                    for (char[] p : parms) {
                        MVEL.analyze(p, pCtx);
                    }
                }
            }
            this.returnType = tk.getEgressType();
        }
        if (!tk.isLiteral() && tk.getClass() == ASTNode.class && (tk.getFields() & 0x4000000) == 0) {
            if (pCtx.isStrongTyping()) {
                tk.strongTyping();
            }
            tk.storePctx();
            tk.storeInLiteralRegister(pCtx);
        }
        return tk;
    }

    public ExpressionCompiler(String expression) {
        this.setExpression(expression);
    }

    public ExpressionCompiler(String expression, boolean verifying) {
        this.setExpression(expression);
        this.verifying = verifying;
    }

    public ExpressionCompiler(char[] expression) {
        this.setExpression(expression);
    }

    public ExpressionCompiler(String expression, ParserContext ctx) {
        this.setExpression(expression);
        this.pCtx = ctx;
    }

    public ExpressionCompiler(char[] expression, int start, int offset) {
        this.expr = expression;
        this.start = start;
        this.end = start + offset;
        this.end = this.trimLeft(this.end);
        this.length = this.end - start;
    }

    public ExpressionCompiler(String expression, int start, int offset, ParserContext ctx) {
        this.expr = expression.toCharArray();
        this.start = start;
        this.end = start + offset;
        this.end = this.trimLeft(this.end);
        this.length = this.end - start;
        this.pCtx = ctx;
    }

    public ExpressionCompiler(char[] expression, int start, int offset, ParserContext ctx) {
        this.expr = expression;
        this.start = start;
        this.end = start + offset;
        this.end = this.trimLeft(this.end);
        this.length = this.end - start;
        this.pCtx = ctx;
    }

    public ExpressionCompiler(char[] expression, ParserContext ctx) {
        this.setExpression(expression);
        this.pCtx = ctx;
    }

    public boolean isVerifying() {
        return this.verifying;
    }

    public void setVerifying(boolean verifying) {
        this.verifying = verifying;
    }

    public boolean isVerifyOnly() {
        return this.verifyOnly;
    }

    public void setVerifyOnly(boolean verifyOnly) {
        this.verifyOnly = verifyOnly;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public ParserContext getParserContextState() {
        return this.pCtx;
    }

    public boolean isLiteralOnly() {
        return this.literalOnly == 1;
    }
}

