/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MyBatisPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private String queryId;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private Map<String, Object> parameterValues;
    private Supplier<Map<String, Object>> parameterValuesSupplier;

    public MyBatisPagingItemReader() {
        this.setName(ClassUtils.getShortName(MyBatisPagingItemReader.class));
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setParameterValuesSupplier(Supplier<Map<String, Object>> parameterValuesSupplier) {
        this.parameterValuesSupplier = parameterValuesSupplier;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.sqlSessionFactory, (String)"A SqlSessionFactory is required.");
        Assert.notNull((Object)this.queryId, (String)"A queryId is required.");
    }

    protected void doReadPage() {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory, ExecutorType.BATCH);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.parameterValues != null) {
            parameters.putAll(this.parameterValues);
        }
        Optional.ofNullable(this.parameterValuesSupplier).map(Supplier::get).ifPresent(parameters::putAll);
        parameters.put("_page", this.getPage());
        parameters.put("_pagesize", this.getPageSize());
        parameters.put("_skiprows", this.getPage() * this.getPageSize());
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        this.results.addAll(this.sqlSessionTemplate.selectList(this.queryId, parameters));
    }

    protected void doJumpToPage(int itemIndex) {
    }
}

