/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import sbt.internal.inc.zip.ZipConstants;
import sbt.internal.inc.zip.ZipUtils;

public class ZipCentralDir {
    private final byte[] cen;
    private END end;
    private final SeekableByteChannel ch;
    private LinkedHashMap<IndexNode, IndexNode> inodes;
    private static byte[] ROOTPATH = new byte[0];
    private final IndexNode LOOKUPKEY = IndexNode.keyOf(null);
    private List<Entry> elist;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public ZipCentralDir(Path path) throws IOException {
        this.ch = Files.newByteChannel(path, StandardOpenOption.READ);
        this.cen = this.initCEN();
        this.elist = this.readEntries();
        this.ch.close();
    }

    public long getCentralDirStart() {
        return this.end.cenoff;
    }

    public void setCentralDirStart(long l) {
        this.end.cenoff = l;
    }

    public List<Entry> getHeaders() {
        return this.elist;
    }

    public void setHeaders(List<Entry> list) {
        this.elist = list;
    }

    public void dump(OutputStream outputStream) throws IOException {
        long l = 0L;
        for (Entry entry : this.elist) {
            l += (long)entry.writeCEN(outputStream);
        }
        this.end.centot = this.elist.size();
        this.end.cenlen = l;
        this.end.write(outputStream, l);
    }

    private List<Entry> readEntries() throws IOException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (IndexNode indexNode : this.inodes.values()) {
            if (indexNode.pos == -1) continue;
            Entry entry = Entry.readCEN(this, indexNode.pos);
            arrayList.add(entry);
        }
        return arrayList;
    }

    private byte[] initCEN() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        long l;
        long l2;
        this.end = this.findEND();
        if (this.end.endpos == 0L) {
            this.inodes = new LinkedHashMap(10);
            long l3 = 0L;
            this.buildNodeTree();
            return null;
        }
        if (this.end.cenlen > this.end.endpos) {
            ZipCentralDir.zerror("invalid END header (bad central directory size)");
        }
        if ((l2 = (l = this.end.endpos - this.end.cenlen) - this.end.cenoff) < 0L) {
            ZipCentralDir.zerror("invalid END header (bad central directory offset)");
        }
        if (this.readFullyAt(byArray = new byte[(int)(this.end.cenlen + 22L)], 0, byArray.length, l) != this.end.cenlen + 22L) {
            ZipCentralDir.zerror("read CEN tables failed");
        }
        this.inodes = new LinkedHashMap(this.end.centot + 1);
        int n5 = byArray.length - 22;
        for (n = 0; n < n5; n += 46 + n4 + n3 + n2) {
            if (ZipConstants.CENSIG(byArray, n) != ZipConstants.CENSIG) {
                ZipCentralDir.zerror("invalid CEN header (bad signature)");
            }
            int n6 = ZipConstants.CENHOW(byArray, n);
            n4 = ZipConstants.CENNAM(byArray, n);
            n3 = ZipConstants.CENEXT(byArray, n);
            n2 = ZipConstants.CENCOM(byArray, n);
            if ((ZipConstants.CENFLG(byArray, n) & 1) != 0) {
                ZipCentralDir.zerror("invalid CEN header (encrypted entry)");
            }
            if (n6 != 0 && n6 != 8) {
                ZipCentralDir.zerror("invalid CEN header (unsupported compression method: " + n6 + ")");
            }
            if (n + 46 + n4 > n5) {
                ZipCentralDir.zerror("invalid CEN header (bad header size)");
            }
            byte[] byArray2 = Arrays.copyOfRange(byArray, n + 46, n + 46 + n4);
            IndexNode indexNode = new IndexNode(byArray2, n);
            this.inodes.put(indexNode, indexNode);
        }
        if (n + 22 != byArray.length) {
            ZipCentralDir.zerror("invalid CEN header (bad header size)");
        }
        this.buildNodeTree();
        return byArray;
    }

    private END findEND() throws IOException {
        byte[] byArray = new byte[128];
        long l = this.ch.size();
        long l2 = l - 65557L > 0L ? l - 65557L : 0L;
        long l3 = l2 - (long)(byArray.length - 22);
        for (long i = l - (long)byArray.length; i >= l3; i -= (long)(byArray.length - 22)) {
            int n;
            int n2 = 0;
            if (i < 0L) {
                n2 = (int)(-i);
                Arrays.fill(byArray, 0, n2, (byte)0);
            }
            if (this.readFullyAt(byArray, n2, n = byArray.length - n2, i + (long)n2) != (long)n) {
                ZipCentralDir.zerror("zip END header not found");
            }
            for (int j = byArray.length - 22; j >= 0; --j) {
                if (byArray[j + 0] != 80 || byArray[j + 1] != 75 || byArray[j + 2] != 5 || byArray[j + 3] != 6 || i + (long)j + 22L + (long)ZipConstants.ENDCOM(byArray, j) != l) continue;
                byArray = Arrays.copyOfRange(byArray, j, j + 22);
                END eND = new END();
                eND.endsub = ZipConstants.ENDSUB(byArray);
                eND.centot = ZipConstants.ENDTOT(byArray);
                eND.cenlen = ZipConstants.ENDSIZ(byArray);
                eND.cenoff = ZipConstants.ENDOFF(byArray);
                eND.comlen = ZipConstants.ENDCOM(byArray);
                eND.endpos = i + (long)j;
                if (eND.cenlen == 0xFFFFFFFFL || eND.cenoff == 0xFFFFFFFFL || eND.centot == 65535) {
                    byte[] byArray2 = new byte[20];
                    if (this.readFullyAt(byArray2, 0, byArray2.length, eND.endpos - 20L) != (long)byArray2.length) {
                        return eND;
                    }
                    byte[] byArray3 = new byte[56];
                    long l4 = ZipConstants.ZIP64_LOCOFF(byArray2);
                    if (this.readFullyAt(byArray3, 0, byArray3.length, l4) != (long)byArray3.length) {
                        return eND;
                    }
                    eND.cenlen = ZipConstants.ZIP64_ENDSIZ(byArray3);
                    eND.cenoff = ZipConstants.ZIP64_ENDOFF(byArray3);
                    eND.centot = (int)ZipConstants.ZIP64_ENDTOT(byArray3);
                    eND.endpos = l4;
                }
                return eND;
            }
        }
        ZipCentralDir.zerror("zip END header not found");
        return null;
    }

    private static void zerror(String string) {
        throw new ZipError(string);
    }

    private void buildNodeTree() {
        HashSet<IndexNode> hashSet = new HashSet<IndexNode>();
        IndexNode indexNode = new IndexNode(ROOTPATH, -1);
        this.inodes.put(indexNode, indexNode);
        hashSet.add(indexNode);
        for (IndexNode indexNode2 : this.inodes.keySet().toArray(new IndexNode[0])) {
            this.addToTree(indexNode2, hashSet);
        }
    }

    private void addToTree(IndexNode indexNode, HashSet<IndexNode> hashSet) {
        IndexNode indexNode2;
        if (hashSet.contains(indexNode)) {
            return;
        }
        byte[] byArray = indexNode.name;
        byte[] byArray2 = ZipCentralDir.getParent(byArray);
        if (this.inodes.containsKey(this.LOOKUPKEY.as(byArray2))) {
            indexNode2 = this.inodes.get(this.LOOKUPKEY);
        } else {
            indexNode2 = new IndexNode(byArray2, -1);
            this.inodes.put(indexNode2, indexNode2);
        }
        this.addToTree(indexNode2, hashSet);
        indexNode.sibling = indexNode2.child;
        indexNode2.child = indexNode;
        if (byArray[byArray.length - 1] == 47) {
            hashSet.add(indexNode);
        }
    }

    private static byte[] getParent(byte[] byArray) {
        int n = byArray.length - 1;
        if (n > 0 && byArray[n] == 47) {
            --n;
        }
        while (n > 0 && byArray[n] != 47) {
            --n;
        }
        if (n <= 0) {
            return ROOTPATH;
        }
        return Arrays.copyOf(byArray, n + 1);
    }

    private long readFullyAt(byte[] byArray, int n, long l, long l2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(n);
        byteBuffer.limit((int)((long)n + l));
        return this.readFullyAt(byteBuffer, l2);
    }

    private long readFullyAt(ByteBuffer byteBuffer, long l) throws IOException {
        return this.ch.position(l).read(byteBuffer);
    }

    public static class Entry
    extends IndexNode {
        int version;
        int flag;
        int method = -1;
        long mtime = -1L;
        long atime = -1L;
        long ctime = -1L;
        long crc = -1L;
        long csize = -1L;
        long size = -1L;
        byte[] extra;
        int versionMade;
        int disk;
        int attrs;
        long attrsEx;
        long locoff;
        byte[] comment;

        Entry() {
        }

        public final long getLastModifiedTime() {
            return this.mtime;
        }

        public final long getEntryOffset() {
            return this.locoff;
        }

        public final void setEntryOffset(long l) {
            this.locoff = l;
        }

        int version() throws ZipException {
            if (this.method == 8) {
                return 20;
            }
            if (this.method == 0) {
                return 10;
            }
            throw new ZipException("unsupported compression method");
        }

        static Entry readCEN(ZipCentralDir zipCentralDir, int n) throws IOException {
            return new Entry().cen(zipCentralDir, n);
        }

        private Entry cen(ZipCentralDir zipCentralDir, int n) throws IOException {
            byte[] byArray = zipCentralDir.cen;
            if (ZipConstants.CENSIG(byArray, n) != ZipConstants.CENSIG) {
                ZipCentralDir.zerror("invalid CEN header (bad signature)");
            }
            this.versionMade = ZipConstants.CENVEM(byArray, n);
            this.version = ZipConstants.CENVER(byArray, n);
            this.flag = ZipConstants.CENFLG(byArray, n);
            this.method = ZipConstants.CENHOW(byArray, n);
            this.mtime = ZipUtils.dosToJavaTime(ZipConstants.CENTIM(byArray, n));
            this.crc = ZipConstants.CENCRC(byArray, n);
            this.csize = ZipConstants.CENSIZ(byArray, n);
            this.size = ZipConstants.CENLEN(byArray, n);
            int n2 = ZipConstants.CENNAM(byArray, n);
            int n3 = ZipConstants.CENEXT(byArray, n);
            int n4 = ZipConstants.CENCOM(byArray, n);
            this.disk = ZipConstants.CENDSK(byArray, n);
            this.attrs = ZipConstants.CENATT(byArray, n);
            this.attrsEx = ZipConstants.CENATX(byArray, n);
            this.locoff = ZipConstants.CENOFF(byArray, n);
            this.setName(Arrays.copyOfRange(byArray, n += 46, n + n2));
            n += n2;
            if (n3 > 0) {
                this.extra = Arrays.copyOfRange(byArray, n, n + n3);
                n += n3;
                this.readExtra(zipCentralDir);
            }
            if (n4 > 0) {
                this.comment = Arrays.copyOfRange(byArray, n, n + n4);
            }
            return this;
        }

        int writeCEN(OutputStream outputStream) throws IOException {
            int n;
            int n2 = this.version();
            long l = this.csize;
            long l2 = this.size;
            long l3 = this.locoff;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            int n6 = this.name != null ? this.name.length : 0;
            int n7 = this.extra != null ? this.extra.length : 0;
            int n8 = 0;
            int n9 = n = this.comment != null ? this.comment.length : 0;
            if (this.csize >= 0xFFFFFFFFL) {
                l = 0xFFFFFFFFL;
                n3 += 8;
            }
            if (this.size >= 0xFFFFFFFFL) {
                l2 = 0xFFFFFFFFL;
                n3 += 8;
            }
            if (this.locoff >= 0xFFFFFFFFL) {
                l3 = 0xFFFFFFFFL;
                n3 += 8;
            }
            if (n3 != 0) {
                n3 += 4;
            }
            while (n8 + 4 < n7) {
                int n10 = ZipConstants.SH(this.extra, n8);
                int n11 = ZipConstants.SH(this.extra, n8 + 2);
                if (n10 == 21589 || n10 == 10) {
                    bl = true;
                }
                n8 += 4 + n11;
            }
            if (!bl) {
                if (isWindows) {
                    n4 = 36;
                } else {
                    n5 = 9;
                }
            }
            ZipUtils.writeInt(outputStream, ZipConstants.CENSIG);
            if (n3 != 0) {
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeShort(outputStream, 45);
            } else {
                ZipUtils.writeShort(outputStream, n2);
                ZipUtils.writeShort(outputStream, n2);
            }
            ZipUtils.writeShort(outputStream, this.flag);
            ZipUtils.writeShort(outputStream, this.method);
            ZipUtils.writeInt(outputStream, (int)ZipUtils.javaToDosTime(this.mtime));
            ZipUtils.writeInt(outputStream, this.crc);
            ZipUtils.writeInt(outputStream, l);
            ZipUtils.writeInt(outputStream, l2);
            ZipUtils.writeShort(outputStream, this.name.length);
            ZipUtils.writeShort(outputStream, n7 + n3 + n4 + n5);
            if (this.comment != null) {
                ZipUtils.writeShort(outputStream, Math.min(n, 65535));
            } else {
                ZipUtils.writeShort(outputStream, 0);
            }
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeInt(outputStream, 0L);
            ZipUtils.writeInt(outputStream, l3);
            ZipUtils.writeBytes(outputStream, this.name);
            if (n3 != 0) {
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, n3 - 4);
                if (l2 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.size);
                }
                if (l == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.csize);
                }
                if (l3 == 0xFFFFFFFFL) {
                    ZipUtils.writeLong(outputStream, this.locoff);
                }
            }
            if (n4 != 0) {
                ZipUtils.writeShort(outputStream, 10);
                ZipUtils.writeShort(outputStream, n4 - 4);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeShort(outputStream, 1);
                ZipUtils.writeShort(outputStream, 24);
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.mtime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.atime));
                ZipUtils.writeLong(outputStream, ZipUtils.javaToWinTime(this.ctime));
            }
            if (n5 != 0) {
                ZipUtils.writeShort(outputStream, 21589);
                ZipUtils.writeShort(outputStream, n5 - 4);
                if (this.ctime == -1L) {
                    outputStream.write(3);
                } else {
                    outputStream.write(7);
                }
                ZipUtils.writeInt(outputStream, ZipUtils.javaToUnixTime(this.mtime));
            }
            if (this.extra != null) {
                ZipUtils.writeBytes(outputStream, this.extra);
            }
            if (this.comment != null) {
                ZipUtils.writeBytes(outputStream, this.comment);
            }
            return 46 + n6 + n7 + n + n3 + n4 + n5;
        }

        void readExtra(ZipCentralDir zipCentralDir) throws IOException {
            if (this.extra == null) {
                return;
            }
            int n = this.extra.length;
            int n2 = 0;
            int n3 = 0;
            while (n2 + 4 < n) {
                int n4;
                int n5 = n2;
                int n6 = ZipConstants.SH(this.extra, n5);
                if ((n5 += 4) + (n4 = ZipConstants.SH(this.extra, n5 + 2)) > n) break;
                block0 : switch (n6) {
                    case 1: {
                        if (this.size == 0xFFFFFFFFL) {
                            if (n5 + 8 > n) break;
                            this.size = ZipConstants.LL(this.extra, n5);
                            n5 += 8;
                        }
                        if (this.csize == 0xFFFFFFFFL) {
                            if (n5 + 8 > n) break;
                            this.csize = ZipConstants.LL(this.extra, n5);
                            n5 += 8;
                        }
                        if (this.locoff != 0xFFFFFFFFL || n5 + 8 > n) break;
                        this.locoff = ZipConstants.LL(this.extra, n5);
                        n5 += 8;
                        break;
                    }
                    case 10: {
                        if (n4 < 32 || ZipConstants.SH(this.extra, n5 += 4) != 1 || ZipConstants.SH(this.extra, n5 + 2) != 24) break;
                        this.mtime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 4));
                        this.atime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 12));
                        this.ctime = ZipUtils.winToJavaTime(ZipConstants.LL(this.extra, n5 + 20));
                        break;
                    }
                    case 21589: {
                        byte[] byArray = new byte[30];
                        if (zipCentralDir.readFullyAt(byArray, 0, byArray.length, this.locoff) != (long)byArray.length) {
                            throw new ZipException("loc: reading failed");
                        }
                        if (ZipConstants.LOCSIG(byArray) != ZipConstants.LOCSIG) {
                            throw new ZipException("loc: wrong sig ->" + Long.toString(ZipConstants.LOCSIG(byArray), 16));
                        }
                        int n7 = ZipConstants.LOCEXT(byArray);
                        if (n7 < 9) break;
                        byArray = new byte[n7];
                        int n8 = ZipConstants.LOCNAM(byArray);
                        if (zipCentralDir.readFullyAt(byArray, 0, byArray.length, this.locoff + 30L + (long)n8) != (long)byArray.length) {
                            throw new ZipException("loc extra: reading failed");
                        }
                        int n9 = 0;
                        while (n9 + 4 < byArray.length) {
                            int n10;
                            int n11 = ZipConstants.SH(byArray, n9);
                            int n12 = ZipConstants.SH(byArray, n9 + 2);
                            n9 += 4;
                            if (n11 != 21589) {
                                n9 += n12;
                                continue;
                            }
                            if (((n10 = ZipConstants.CH(byArray, n9++)) & 1) != 0) {
                                this.mtime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                                n9 += 4;
                            }
                            if ((n10 & 2) != 0) {
                                this.atime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                                n9 += 4;
                            }
                            if ((n10 & 4) == 0) break block0;
                            this.ctime = ZipUtils.unixToJavaTime(ZipConstants.LG(byArray, n9));
                            n9 += 4;
                            break block0;
                        }
                        break;
                    }
                    default: {
                        System.arraycopy(this.extra, n2, this.extra, n3, n4 + 4);
                        n3 += n4 + 4;
                    }
                }
                n2 += n4 + 4;
            }
            this.extra = (byte[])(n3 != 0 && n3 != this.extra.length ? Arrays.copyOf(this.extra, n3) : null);
        }
    }

    static class END {
        int endsub;
        int centot;
        long cenlen;
        long cenoff;
        int comlen;
        byte[] comment;
        long endpos;

        END() {
        }

        void write(OutputStream outputStream, long l) throws IOException {
            int n;
            boolean bl = false;
            long l2 = this.cenlen;
            long l3 = this.cenoff;
            if (l2 >= 0xFFFFFFFFL) {
                l2 = 0xFFFFFFFFL;
                bl = true;
            }
            if (l3 >= 0xFFFFFFFFL) {
                l3 = 0xFFFFFFFFL;
                bl = true;
            }
            if ((n = this.centot) >= 65535) {
                n = 65535;
                bl = true;
            }
            if (bl) {
                long l4 = l;
                ZipUtils.writeInt(outputStream, 101075792L);
                ZipUtils.writeLong(outputStream, 44L);
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeShort(outputStream, 45);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeLong(outputStream, this.centot);
                ZipUtils.writeLong(outputStream, this.centot);
                ZipUtils.writeLong(outputStream, this.cenlen);
                ZipUtils.writeLong(outputStream, this.cenoff);
                ZipUtils.writeInt(outputStream, 117853008L);
                ZipUtils.writeInt(outputStream, 0L);
                ZipUtils.writeLong(outputStream, l4);
                ZipUtils.writeInt(outputStream, 1L);
            }
            ZipUtils.writeInt(outputStream, ZipConstants.ENDSIG);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, 0);
            ZipUtils.writeShort(outputStream, n);
            ZipUtils.writeShort(outputStream, n);
            ZipUtils.writeInt(outputStream, l2);
            ZipUtils.writeInt(outputStream, l3);
            if (this.comment != null) {
                ZipUtils.writeShort(outputStream, this.comment.length);
                ZipUtils.writeBytes(outputStream, this.comment);
            } else {
                ZipUtils.writeShort(outputStream, 0);
            }
        }
    }

    static class IndexNode {
        byte[] name;
        int hashcode;
        int pos = -1;
        String nameAsString;
        IndexNode sibling;
        IndexNode child;

        IndexNode(byte[] byArray, int n) {
            this.setName(byArray);
            this.pos = n;
        }

        static IndexNode keyOf(byte[] byArray) {
            return new IndexNode(byArray, -1);
        }

        public final void setName(byte[] byArray) {
            this.name = byArray;
            this.hashcode = Arrays.hashCode(byArray);
        }

        public final String getName() {
            if (this.nameAsString == null) {
                this.nameAsString = new String(this.name);
            }
            return this.nameAsString;
        }

        final IndexNode as(byte[] byArray) {
            this.setName(byArray);
            return this;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexNode)) {
                return false;
            }
            return Arrays.equals(this.name, ((IndexNode)object).name);
        }

        public int hashCode() {
            return this.hashcode;
        }

        IndexNode() {
        }
    }
}

