/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.observation;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.model.observation.ModelUsageMetricsGenerator;

public class ChatModelMeterObservationHandler
implements ObservationHandler<ChatModelObservationContext> {
    private final MeterRegistry meterRegistry;

    public ChatModelMeterObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void onStop(ChatModelObservationContext context) {
        if (context.getResponse() != null && ((ChatResponse)context.getResponse()).getMetadata() != null && ((ChatResponse)context.getResponse()).getMetadata().getUsage() != null) {
            ModelUsageMetricsGenerator.generate(((ChatResponse)context.getResponse()).getMetadata().getUsage(), context, this.meterRegistry);
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatModelObservationContext;
    }
}

