/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRuleManager;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.alibaba.sentinel.datasource.DataSourceLoader;
import org.springframework.cloud.alibaba.sentinel.datasource.SentinelDataSourceRegistry;
import org.springframework.cloud.alibaba.sentinel.datasource.annotation.SentinelDataSource;
import org.springframework.cloud.alibaba.sentinel.datasource.util.PropertySourcesUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SentinelDataSourcePostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SentinelDataSourcePostProcessor.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ConfigurableEnvironment environment;
    private final Map<String, List<SentinelDataSourceField>> dataSourceFieldCache = new ConcurrentHashMap<String, List<SentinelDataSourceField>>(64);

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, final String beanName) {
        ReflectionUtils.doWithFields(beanType, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                SentinelDataSource annotation = (SentinelDataSource)AnnotationUtils.getAnnotation((AnnotatedElement)field, SentinelDataSource.class);
                if (annotation != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("@SentinelDataSource annotation is not supported on static fields: " + field);
                        }
                        return;
                    }
                    if (SentinelDataSourcePostProcessor.this.dataSourceFieldCache.containsKey(beanName)) {
                        ((List)SentinelDataSourcePostProcessor.this.dataSourceFieldCache.get(beanName)).add(new SentinelDataSourceField(annotation, field));
                    } else {
                        ArrayList<SentinelDataSourceField> list = new ArrayList<SentinelDataSourceField>();
                        list.add(new SentinelDataSourceField(annotation, field));
                        SentinelDataSourcePostProcessor.this.dataSourceFieldCache.put(beanName, list);
                    }
                }
            }
        });
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        if (this.dataSourceFieldCache.containsKey(beanName)) {
            List<SentinelDataSourceField> sentinelDataSourceFields = this.dataSourceFieldCache.get(beanName);
            sentinelDataSourceFields.forEach(sentinelDataSourceField -> {
                try {
                    Field field = sentinelDataSourceField.getField();
                    ReflectionUtils.makeAccessible((Field)field);
                    String dataSourceBeanName = this.constructDataSource(sentinelDataSourceField.getSentinelDataSource());
                    field.set(bean, this.applicationContext.getBean(dataSourceBeanName));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return pvs;
    }

    private String constructDataSource(SentinelDataSource annotation) {
        String beanName;
        String prefix = annotation.value();
        if (StringUtils.isEmpty((Object)prefix)) {
            prefix = "spring.cloud.sentinel.datasource";
        }
        Map<String, Object> propertyMap = PropertySourcesUtils.getSubProperties(this.environment.getPropertySources(), prefix);
        String alias = propertyMap.get("type").toString();
        Class<? extends ReadableDataSource> dataSourceClass = DataSourceLoader.loadClass(alias);
        String string = beanName = StringUtils.isEmpty((Object)annotation.name()) ? StringUtils.uncapitalize((String)dataSourceClass.getSimpleName()) + "_" + prefix : annotation.name();
        if (this.applicationContext.containsBean(beanName)) {
            return beanName;
        }
        Class<Object> targetClass = null;
        targetClass = SentinelDataSourceRegistry.checkFactoryBean(alias) ? SentinelDataSourceRegistry.getFactoryBean(alias) : dataSourceClass;
        this.registerDataSource(beanName, targetClass, propertyMap);
        return beanName;
    }

    private void registerDataSource(String beanName, Class targetClass, Map<String, Object> propertyMap) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((Class)targetClass);
        for (String propertyName : propertyMap.keySet()) {
            Field field = ReflectionUtils.findField((Class)targetClass, (String)propertyName);
            if (field == null) continue;
            if (field.getType().isAssignableFrom(Converter.class)) {
                builder.addPropertyReference(propertyName, propertyMap.get(propertyName).toString());
                continue;
            }
            builder.addPropertyValue(propertyName, propertyMap.get(propertyName));
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    @EventListener(classes={ApplicationStartedEvent.class})
    public void appStartedListener(ApplicationStartedEvent event) throws Exception {
        logger.info("[Sentinel Starter] Start to find ReadableDataSource");
        Map dataSourceMap = event.getApplicationContext().getBeansOfType(ReadableDataSource.class);
        if (dataSourceMap.size() == 1) {
            logger.info("[Sentinel Starter] There exists only one ReadableDataSource named {}, start to load rules", dataSourceMap.keySet().iterator().next());
            ReadableDataSource dataSource = (ReadableDataSource)dataSourceMap.values().iterator().next();
            Object ruleConfig = dataSource.loadConfig();
            SentinelProperty sentinelProperty = dataSource.getProperty();
            Integer rulesNum = this.checkRuleType(ruleConfig, FlowRule.class);
            if (rulesNum > 0) {
                FlowRuleManager.register2Property((SentinelProperty)sentinelProperty);
                logger.info("[Sentinel Starter] load {} flow rules", (Object)rulesNum);
            }
            if ((rulesNum = this.checkRuleType(ruleConfig, DegradeRule.class)) > 0) {
                DegradeRuleManager.register2Property((SentinelProperty)sentinelProperty);
                logger.info("[Sentinel Starter] load {} degrade rules", (Object)rulesNum);
            }
            if ((rulesNum = this.checkRuleType(ruleConfig, SystemRule.class)) > 0) {
                SystemRuleManager.register2Property((SentinelProperty)sentinelProperty);
                logger.info("[Sentinel Starter] load {} system rules", (Object)rulesNum);
            }
            if ((rulesNum = this.checkRuleType(ruleConfig, AuthorityRule.class)) > 0) {
                AuthorityRuleManager.register2Property((SentinelProperty)sentinelProperty);
                logger.info("[Sentinel Starter] load {} authority rules", (Object)rulesNum);
            }
        } else if (dataSourceMap.size() > 1) {
            logger.warn("[Sentinel Starter] There exists more than one ReadableDataSource, can not choose which one to load");
        } else {
            logger.warn("[Sentinel Starter] No ReadableDataSource exists");
        }
    }

    private Integer checkRuleType(Object ruleConfig, Class type) {
        List ruleList;
        if (ruleConfig.getClass() == type) {
            return 1;
        }
        if (ruleConfig instanceof List && (ruleList = (List)ruleConfig).stream().filter(rule -> rule.getClass() == type).toArray().length == ruleList.size()) {
            return ruleList.size();
        }
        return -1;
    }

    class SentinelDataSourceField {
        private SentinelDataSource sentinelDataSource;
        private Field field;

        public SentinelDataSourceField(SentinelDataSource sentinelDataSource, Field field) {
            this.sentinelDataSource = sentinelDataSource;
            this.field = field;
        }

        public SentinelDataSource getSentinelDataSource() {
            return this.sentinelDataSource;
        }

        public void setSentinelDataSource(SentinelDataSource sentinelDataSource) {
            this.sentinelDataSource = sentinelDataSource;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }
    }
}

