/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.AbstractFileObject;

public abstract class URLFileObject
extends AbstractFileObject {
    protected String path;
    protected String fileName;
    private URL url;
    private String extName;
    private long fileSize;
    private List<FileObject> children;

    public URLFileObject(SchemaProvider schemaProvider) {
        super(schemaProvider);
    }

    public URLFileObject(SchemaProvider schemaProvider, String resource) {
        super(schemaProvider);
        try {
            this.url = new URL(resource);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("\u4e0d\u80fd\u5b9a\u4f4d\u5230\u8d44\u6e90:" + resource, e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public String getAbsolutePath() {
        return this.url.getPath();
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.getParent() == null ? "" : this.getParent().getPath() + "/" + this.getFileName();
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            String absolutePath = this.getAbsolutePath();
            int lastIndex = absolutePath.lastIndexOf(47);
            this.fileName = lastIndex != -1 ? absolutePath.substring(lastIndex + 1) : "";
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getExtName() {
        if (this.extName == null) {
            String name = this.getFileName();
            int lastIndex = name.lastIndexOf(46);
            this.extName = lastIndex != -1 ? name.substring(lastIndex + 1) : "";
        }
        return this.extName;
    }

    public void setExtName(String extName) {
        this.extName = extName;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isExist() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        InputStream stream = null;
        try {
            stream = this.url.openStream();
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
        return stream;
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            URLConnection connection = this.url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            return connection.getOutputStream();
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
    }

    @Override
    public FileObject getChild(String fileName) {
        List<FileObject> child = this.getChildren();
        if (child == null || child.size() == 0) {
            return null;
        }
        for (FileObject fileObject : this.getChildren()) {
            if (!fileObject.getFileName().equals(fileName)) continue;
            return fileObject;
        }
        return null;
    }

    @Override
    public List<FileObject> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<FileObject>();
        }
        return this.children;
    }

    @Override
    public boolean isInPackage() {
        return false;
    }

    @Override
    public URL getURL() {
        return this.url;
    }
}

