/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.SchemaProvider;
import org.tinygroup.vfs.VFSRuntimeException;
import org.tinygroup.vfs.impl.AbstractFileObject;

public class ZipFileObject
extends AbstractFileObject {
    private List<FileObject> children;
    private ZipFile zipFile = null;
    private File file = null;
    private ZipEntry zipEntry = null;
    private File cacheFile = null;

    public ZipFileObject(SchemaProvider schemaProvider, String resource) {
        super(schemaProvider);
        try {
            this.file = new File(resource);
            if (this.file.exists()) {
                this.zipFile = new ZipFile(resource);
            }
        }
        catch (IOException e) {
            throw new VFSRuntimeException(resource + "\u6253\u5f00\u5931\u8d25\uff0c\u9519\u8bef\uff1a" + e.getMessage(), e);
        }
    }

    public ZipFileObject(ZipFileObject parent, ZipEntry entry) {
        super(parent.getSchemaProvider());
        this.zipFile = parent.zipFile;
        this.file = parent.file;
        this.zipEntry = entry;
    }

    @Override
    public void clean() {
        try {
            this.zipFile.close();
        }
        catch (IOException e) {
            throw new VFSRuntimeException(e);
        }
    }

    @Override
    public String getFileName() {
        if (this.zipEntry != null) {
            String[] names = this.zipEntry.getName().split("/");
            return names[names.length - 1];
        }
        return this.file.getName();
    }

    @Override
    public String getPath() {
        if (this.zipEntry != null) {
            return "/" + this.zipEntry.getName();
        }
        return "/";
    }

    @Override
    public String getAbsolutePath() {
        String path = this.file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            path = path.replaceAll("\\\\", "/");
        }
        if (this.zipEntry != null) {
            path = path + "!/" + this.zipEntry.getName();
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getExtName() {
        String name;
        if (this.zipEntry != null) {
            if (this.zipEntry.isDirectory()) return null;
            name = this.zipEntry.getName();
        } else {
            name = this.file.getName();
        }
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot != -1) return name.substring(lastIndexOfDot + 1);
        return null;
    }

    @Override
    public long getSize() {
        if (this.zipEntry != null) {
            return this.zipEntry.getSize();
        }
        if (this.file.exists() && this.file.isFile()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() {
        try {
            if (this.zipEntry != null) {
                if (this.cacheFile == null || !this.cacheFile.exists() || this.cacheFile.length() != this.getSize()) {
                    this.createCacheFile();
                    FileOutputStream out = new FileOutputStream(this.cacheFile);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipEntry));
                    StreamUtil.io((InputStream)bufferedInputStream, (OutputStream)out, (boolean)true, (boolean)true);
                }
                return new BufferedInputStream(new FileInputStream(this.cacheFile));
            }
            if (this.file.exists() && this.file.isFile()) {
                return new ZipInputStream(new FileInputStream(this.file));
            }
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u6587\u4ef6\u3002");
        }
        catch (Exception e) {
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u83b7\u53d6FileInputStream\u51fa\u9519\uff0c\u539f\u56e0" + e);
        }
    }

    private void createCacheFile() {
        boolean created;
        File tempPathFile;
        String tempPath = System.getProperty("java.io.tmpdir");
        if (!tempPath.endsWith(File.separator)) {
            tempPath = tempPath + File.separator;
        }
        if (!(tempPathFile = new File(tempPath = tempPath + this.getExtName() + File.separator)).exists() && !(created = tempPathFile.mkdirs())) {
            throw new VFSRuntimeException("\u521b\u5efa\u4e34\u65f6\u76ee\u5f55" + tempPath + "\u5931\u8d25\uff01");
        }
        this.cacheFile = new File(tempPath + this.getFileName() + "_" + this.getLastModifiedTime());
    }

    public String toString() {
        return this.getURL().toString();
    }

    @Override
    public boolean isFolder() {
        if (this.zipEntry != null) {
            return this.zipEntry.isDirectory();
        }
        return this.file.exists();
    }

    @Override
    public List<FileObject> getChildren() {
        if (!this.file.exists()) {
            return null;
        }
        if (this.children == null) {
            this.children = new ArrayList<FileObject>();
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                String fn;
                String[] names;
                ZipEntry entry = e.nextElement();
                if (this.getParent() == null) {
                    String[] names2 = entry.getName().split("/");
                    if (names2.length != 1) continue;
                    this.addSubItem(entry);
                    continue;
                }
                String parentName = this.zipEntry.getName();
                if (entry.getName().equals(this.zipEntry.getName()) || !entry.getName().startsWith(parentName) || (names = (fn = entry.getName().substring(parentName.length())).split("/")).length != 1) continue;
                this.addSubItem(entry);
            }
        }
        return this.children;
    }

    private void addSubItem(ZipEntry entry) {
        ZipFileObject zipFileObject = new ZipFileObject(this, entry);
        zipFileObject.setParent(this);
        this.children.add(zipFileObject);
    }

    @Override
    public long getLastModifiedTime() {
        if (this.zipEntry != null) {
            return this.zipEntry.getTime();
        }
        return this.file.lastModified();
    }

    @Override
    public boolean isExist() {
        if (this.zipEntry != null) {
            return true;
        }
        return this.file.exists();
    }

    @Override
    public boolean isInPackage() {
        return this.zipFile != null;
    }

    @Override
    public FileObject getChild(String fileName) {
        if (this.getChildren() != null) {
            for (FileObject fileObject : this.getChildren()) {
                if (!fileObject.getFileName().equals(fileName)) continue;
                return fileObject;
            }
        }
        return null;
    }

    @Override
    public URL getURL() {
        try {
            if (this.zipEntry != null) {
                return new URL("zip:file:" + this.getAbsolutePath());
            }
            return new URL("file:" + this.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new VFSRuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            if (this.zipEntry != null) {
                if (this.cacheFile == null || !this.cacheFile.exists() || this.cacheFile.length() != this.getSize()) {
                    this.createCacheFile();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.zipFile.getInputStream(this.zipEntry));
                    FileOutputStream out = new FileOutputStream(this.cacheFile);
                    StreamUtil.io((InputStream)bufferedInputStream, (OutputStream)out, (boolean)true, (boolean)true);
                }
                return new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            }
            if (this.file.exists() && this.file.isFile()) {
                return new ZipOutputStream(new FileOutputStream(this.file));
            }
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u6587\u4ef6\u3002");
        }
        catch (Exception e) {
            throw new VFSRuntimeException(this.file.getAbsolutePath() + "\u83b7\u53d6outputStream\u51fa\u9519\uff0c\u539f\u56e0" + e);
        }
    }
}

