/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl.filter;

import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;

public class FileExtNameFileObjectFilter
implements FileObjectFilter {
    private String fileExtName;
    private boolean caseSensitive = false;

    public FileExtNameFileObjectFilter(String fileExtName) {
        this.fileExtName = fileExtName;
    }

    public FileExtNameFileObjectFilter(String fileExtName, boolean caseSensitive) {
        this(fileExtName);
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean accept(FileObject fileObject) {
        String extName = fileObject.getExtName();
        if (extName != null) {
            if (this.caseSensitive) {
                return extName.equals(this.fileExtName);
            }
            return extName.equalsIgnoreCase(this.fileExtName);
        }
        return false;
    }
}

