/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.vfs.impl.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.vfs.FileObjectFilter;

public class FileNameFileObjectFilter
implements FileObjectFilter {
    private Pattern pattern;
    private boolean fullMatch = false;

    public FileNameFileObjectFilter(String fileNamePattern) {
        this.pattern = Pattern.compile(fileNamePattern);
    }

    public FileNameFileObjectFilter(String fileNamePattern, boolean fullMatch) {
        this(fileNamePattern);
        this.fullMatch = fullMatch;
    }

    @Override
    public boolean accept(FileObject fileObject) {
        String fileName = fileObject.getFileName();
        if (this.fullMatch) {
            Matcher matcher = this.pattern.matcher(fileName);
            if (matcher.find()) {
                return matcher.group().equals(fileName);
            }
            return false;
        }
        Matcher matcher = this.pattern.matcher(fileName);
        return matcher.find();
    }
}

