/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosNull;
import org.verapdf.gf.model.impl.cos.GFCosObject;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosNull;
import org.verapdf.model.coslayer.CosObject;

public class GFCosIndirect
extends GFCosObject
implements CosIndirect {
    public static final String DIRECT_OBJECT = "directObject";
    public static final String COS_INDIRECT_TYPE = "CosIndirect";
    private final boolean isSpacingPDFACompliant;
    private final String id;

    public GFCosIndirect(COSKey key, COSObject object) {
        super(object.get(), COS_INDIRECT_TYPE);
        this.isSpacingPDFACompliant = GFCosIndirect.getspacingCompliesPDFA(object);
        this.id = GFIDGenerator.generateID(key);
    }

    public GFCosIndirect(COSIndirect object) {
        super(object.get(), COS_INDIRECT_TYPE);
        this.isSpacingPDFACompliant = GFCosIndirect.getspacingCompliesPDFA(object.getDirect());
        this.id = GFIDGenerator.generateID(object.getKey());
    }

    public String getID() {
        return this.id;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (DIRECT_OBJECT.equals(link)) {
            return this.parseDirectObject();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosObject> parseDirectObject() {
        ArrayList<CosNull> list = new ArrayList<CosNull>();
        list.add((CosNull)(this.baseObject != null ? GFCosIndirect.getFromValue(this.baseObject) : GFCosNull.getInstance()));
        return Collections.unmodifiableList(list);
    }

    public Boolean getspacingCompliesPDFA() {
        return this.isSpacingPDFACompliant;
    }

    private static boolean getspacingCompliesPDFA(COSObject object) {
        return object.isEndOfObjectComplyPDFA() != false && object.isHeaderFormatComplyPDFA() != false && object.isHeaderOfObjectComplyPDFA() != false;
    }
}

