/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.http.jetty;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.remoting.http.HttpHandler;
import com.alibaba.dubbo.remoting.http.servlet.DispatcherServlet;
import com.alibaba.dubbo.remoting.http.support.AbstractHttpServer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class JettyHttpServer
extends AbstractHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyHttpServer.class);
    private Server server;

    public JettyHttpServer(URL url, HttpHandler handler) {
        super(url, handler);
        DispatcherServlet.addHttpHandler(url.getParameter("bind.port", url.getPort()), handler);
        int threads = url.getParameter("threads", 200);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        threadPool.setMaxThreads(threads);
        threadPool.setMinThreads(threads);
        SelectChannelConnector connector = new SelectChannelConnector();
        String bindIp = url.getParameter("bind.ip", url.getHost());
        if (!url.isAnyHost() && NetUtils.isValidLocalHost(bindIp)) {
            connector.setHost(bindIp);
        }
        connector.setPort(url.getParameter("bind.port", url.getPort()));
        this.server = new Server();
        this.server.setThreadPool((ThreadPool)threadPool);
        this.server.addConnector((Connector)connector);
        ServletHandler servletHandler = new ServletHandler();
        ServletHolder servletHolder = servletHandler.addServletWithMapping(DispatcherServlet.class, "/*");
        servletHolder.setInitOrder(2);
        this.server.addHandler((Handler)servletHandler);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to start jetty server on " + url.getParameter("bind.ip") + ":" + url.getParameter("bind.port") + ", cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }
}

