/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.aliyuncs.domain.model.v20180129;

import com.aliyuncs.RpcAcsRequest;

/**
 * @author auto create
 * @version 
 */
public class SaveRegistrantProfileRequest extends RpcAcsRequest<SaveRegistrantProfileResponse> {
	
	public SaveRegistrantProfileRequest() {
		super("Domain", "2018-01-29", "SaveRegistrantProfile");
	}

	private String country;

	private String address;

	private String telArea;

	private String city;

	private Long registrantProfileId;

	private String zhAddress;

	private String registrantType;

	private String telephone;

	private Boolean defaultRegistrantProfile;

	private String zhCity;

	private String zhProvince;

	private String registrantOrganization;

	private String telExt;

	private String province;

	private String zhRegistrantName;

	private String postalCode;

	private String userClientIp;

	private String lang;

	private String email;

	private String registrantName;

	private String zhRegistrantOrganization;

	public String getCountry() {
		return this.country;
	}

	public void setCountry(String country) {
		this.country = country;
		if(country != null){
			putQueryParameter("Country", country);
		}
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String address) {
		this.address = address;
		if(address != null){
			putQueryParameter("Address", address);
		}
	}

	public String getTelArea() {
		return this.telArea;
	}

	public void setTelArea(String telArea) {
		this.telArea = telArea;
		if(telArea != null){
			putQueryParameter("TelArea", telArea);
		}
	}

	public String getCity() {
		return this.city;
	}

	public void setCity(String city) {
		this.city = city;
		if(city != null){
			putQueryParameter("City", city);
		}
	}

	public Long getRegistrantProfileId() {
		return this.registrantProfileId;
	}

	public void setRegistrantProfileId(Long registrantProfileId) {
		this.registrantProfileId = registrantProfileId;
		if(registrantProfileId != null){
			putQueryParameter("RegistrantProfileId", registrantProfileId.toString());
		}
	}

	public String getZhAddress() {
		return this.zhAddress;
	}

	public void setZhAddress(String zhAddress) {
		this.zhAddress = zhAddress;
		if(zhAddress != null){
			putQueryParameter("ZhAddress", zhAddress);
		}
	}

	public String getRegistrantType() {
		return this.registrantType;
	}

	public void setRegistrantType(String registrantType) {
		this.registrantType = registrantType;
		if(registrantType != null){
			putQueryParameter("RegistrantType", registrantType);
		}
	}

	public String getTelephone() {
		return this.telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
		if(telephone != null){
			putQueryParameter("Telephone", telephone);
		}
	}

	public Boolean getDefaultRegistrantProfile() {
		return this.defaultRegistrantProfile;
	}

	public void setDefaultRegistrantProfile(Boolean defaultRegistrantProfile) {
		this.defaultRegistrantProfile = defaultRegistrantProfile;
		if(defaultRegistrantProfile != null){
			putQueryParameter("DefaultRegistrantProfile", defaultRegistrantProfile.toString());
		}
	}

	public String getZhCity() {
		return this.zhCity;
	}

	public void setZhCity(String zhCity) {
		this.zhCity = zhCity;
		if(zhCity != null){
			putQueryParameter("ZhCity", zhCity);
		}
	}

	public String getZhProvince() {
		return this.zhProvince;
	}

	public void setZhProvince(String zhProvince) {
		this.zhProvince = zhProvince;
		if(zhProvince != null){
			putQueryParameter("ZhProvince", zhProvince);
		}
	}

	public String getRegistrantOrganization() {
		return this.registrantOrganization;
	}

	public void setRegistrantOrganization(String registrantOrganization) {
		this.registrantOrganization = registrantOrganization;
		if(registrantOrganization != null){
			putQueryParameter("RegistrantOrganization", registrantOrganization);
		}
	}

	public String getTelExt() {
		return this.telExt;
	}

	public void setTelExt(String telExt) {
		this.telExt = telExt;
		if(telExt != null){
			putQueryParameter("TelExt", telExt);
		}
	}

	public String getProvince() {
		return this.province;
	}

	public void setProvince(String province) {
		this.province = province;
		if(province != null){
			putQueryParameter("Province", province);
		}
	}

	public String getZhRegistrantName() {
		return this.zhRegistrantName;
	}

	public void setZhRegistrantName(String zhRegistrantName) {
		this.zhRegistrantName = zhRegistrantName;
		if(zhRegistrantName != null){
			putQueryParameter("ZhRegistrantName", zhRegistrantName);
		}
	}

	public String getPostalCode() {
		return this.postalCode;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
		if(postalCode != null){
			putQueryParameter("PostalCode", postalCode);
		}
	}

	public String getUserClientIp() {
		return this.userClientIp;
	}

	public void setUserClientIp(String userClientIp) {
		this.userClientIp = userClientIp;
		if(userClientIp != null){
			putQueryParameter("UserClientIp", userClientIp);
		}
	}

	public String getLang() {
		return this.lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
		if(lang != null){
			putQueryParameter("Lang", lang);
		}
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
		if(email != null){
			putQueryParameter("Email", email);
		}
	}

	public String getRegistrantName() {
		return this.registrantName;
	}

	public void setRegistrantName(String registrantName) {
		this.registrantName = registrantName;
		if(registrantName != null){
			putQueryParameter("RegistrantName", registrantName);
		}
	}

	public String getZhRegistrantOrganization() {
		return this.zhRegistrantOrganization;
	}

	public void setZhRegistrantOrganization(String zhRegistrantOrganization) {
		this.zhRegistrantOrganization = zhRegistrantOrganization;
		if(zhRegistrantOrganization != null){
			putQueryParameter("ZhRegistrantOrganization", zhRegistrantOrganization);
		}
	}

	@Override
	public Class<SaveRegistrantProfileResponse> getResponseClass() {
		return SaveRegistrantProfileResponse.class;
	}

}
