/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.http;

import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.http.HttpMethodName;
import com.baidu.aip.util.AipClientConfiguration;
import com.baidu.aip.util.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AipRequest {
    private HashMap<String, String> headers;
    private HashMap<String, String> params;
    private HashMap<String, Object> body;
    private URI uri;
    private HttpMethodName httpMethod;
    private EBodyFormat bodyFormat;
    private String contentEncoding;
    private AipClientConfiguration config;

    public AipRequest() {
        this.headers = new HashMap();
        this.params = new HashMap();
        this.body = new HashMap();
        this.httpMethod = HttpMethodName.POST;
        this.bodyFormat = EBodyFormat.FORM_KV;
        this.contentEncoding = "UTF8";
        this.config = null;
    }

    public AipRequest(HashMap<String, String> header, HashMap<String, String> bodyParams) {
        this.headers = header;
        this.params = bodyParams;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public EBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setBodyFormat(EBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
        if (key.equals("Content-Encoding")) {
            this.contentEncoding = value;
        }
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void addBody(String key, Object value) {
        this.body.put(key, value);
    }

    public void addBody(HashMap other) {
        if (other != null) {
            this.body.putAll(other);
        }
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public String getBodyStr() {
        ArrayList<String> arr = new ArrayList<String>();
        if (this.bodyFormat.equals((Object)EBodyFormat.FORM_KV)) {
            for (Map.Entry<String, Object> entry : this.body.entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) {
                    arr.add(Util.uriEncode(entry.getKey(), true));
                    continue;
                }
                arr.add(String.format("%s=%s", Util.uriEncode(entry.getKey(), true), Util.uriEncode(entry.getValue().toString(), true)));
            }
            return Util.mkString(arr.iterator(), '&');
        }
        if (this.bodyFormat.equals((Object)EBodyFormat.RAW_JSON)) {
            JSONObject json = new JSONObject();
            for (Map.Entry<String, Object> entry : this.body.entrySet()) {
                json.put(entry.getKey(), entry.getValue());
            }
            return json.toString();
        }
        return "";
    }

    public String getParamStr() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            buffer.append(String.format("%s=%s&", entry.getKey(), entry.getValue()));
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public HashMap<String, Object> getBody() {
        return this.body;
    }

    public void setBody(HashMap<String, Object> body) {
        this.body = body;
    }

    public void setParams(HashMap<String, String> params) {
        this.params = params;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String url) {
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public HttpMethodName getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethodName httpMethod) {
        this.httpMethod = httpMethod;
    }

    public AipClientConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(AipClientConfiguration config) {
        this.config = config;
    }
}

