/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDeployClassesCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientUserCodeDeploymentService {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(.*)\\.class$");
    private final ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig;
    private final ClassLoader configClassLoader;
    private final List<Map.Entry<String, byte[]>> classDefinitionList = new ArrayList<Map.Entry<String, byte[]>>();

    public ClientUserCodeDeploymentService(ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig, ClassLoader configClassLoader) {
        this.clientUserCodeDeploymentConfig = clientUserCodeDeploymentConfig;
        this.configClassLoader = configClassLoader != null ? configClassLoader : ClassLoader.getSystemClassLoader();
    }

    public void start() throws IOException, ClassNotFoundException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled()) {
            return;
        }
        this.loadClassesFromJars();
        this.loadClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClasses() throws ClassNotFoundException {
        for (String className : this.clientUserCodeDeploymentConfig.getClassNames()) {
            String resource = className.replace('.', '/').concat(".class");
            InputStream is = null;
            try {
                is = this.configClassLoader.getResourceAsStream(resource);
                if (is == null) {
                    throw new ClassNotFoundException(resource);
                }
                byte[] bytes = IOUtil.toByteArray((InputStream)is);
                this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, bytes));
            }
            catch (IOException e) {
                try {
                    EmptyStatement.ignore((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
                IOUtil.closeResource((Closeable)is);
                continue;
            }
            IOUtil.closeResource((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJars() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (String jarPath : this.clientUserCodeDeploymentConfig.getJarPaths()) {
                this.loadClassesFromJar(os, jarPath);
            }
        }
        finally {
            IOUtil.closeResource((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJar(ByteArrayOutputStream os, String jarPath) throws IOException {
        JarInputStream inputStream = null;
        try {
            JarEntry entry;
            inputStream = this.getJarInputStream(jarPath);
            while ((entry = inputStream.getNextJarEntry()) != null) {
                String className = this.extractClassName(entry);
                if (className == null) continue;
                byte[] classDefinition = this.readClassDefinition(inputStream, os);
                inputStream.closeEntry();
                this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, classDefinition));
            }
        }
        finally {
            IOUtil.closeResource((Closeable)inputStream);
        }
    }

    private JarInputStream getJarInputStream(String jarPath) throws IOException {
        File file = new File(jarPath);
        if (file.exists()) {
            return new JarInputStream(new FileInputStream(file));
        }
        try {
            URL url = new URL(jarPath);
            return new JarInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            EmptyStatement.ignore((Throwable)e);
            InputStream inputStream = this.configClassLoader.getResourceAsStream(jarPath);
            if (inputStream == null) {
                throw new FileNotFoundException("File could not be found in " + jarPath + "  and resources/" + jarPath);
            }
            return new JarInputStream(inputStream);
        }
    }

    private byte[] readClassDefinition(JarInputStream inputStream, ByteArrayOutputStream os) throws IOException {
        int v;
        os.reset();
        while ((v = inputStream.read()) != -1) {
            os.write(v);
        }
        return os.toByteArray();
    }

    private String extractClassName(JarEntry entry) {
        String entryName = entry.getName();
        Matcher matcher = CLASS_PATTERN.matcher(entryName.replace('/', '.'));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public void deploy(HazelcastClientInstanceImpl client, Connection ownerConnection) throws ExecutionException, InterruptedException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled()) {
            return;
        }
        ClientMessage request = ClientDeployClassesCodec.encodeRequest(this.classDefinitionList);
        ClientInvocation invocation = new ClientInvocation(client, request, null, ownerConnection);
        ClientInvocationFuture future = invocation.invokeUrgent();
        future.get();
    }

    public List<Map.Entry<String, byte[]>> getClassDefinitionList() {
        return this.classDefinitionList;
    }
}

