/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class AuthenticationSuccessResponse
extends AuthorizationSuccessResponse
implements AuthenticationResponse {
    private final JWT idToken;
    private final State sessionState;

    public AuthenticationSuccessResponse(URI redirectURI, AuthorizationCode code, JWT idToken, AccessToken accessToken, State state, State sessionState, ResponseMode rm) {
        super(redirectURI, code, accessToken, state, rm);
        this.idToken = idToken;
        this.sessionState = sessionState;
    }

    @Override
    public ResponseType impliedResponseType() {
        ResponseType rt = new ResponseType();
        if (this.getAuthorizationCode() != null) {
            rt.add(ResponseType.Value.CODE);
        }
        if (this.getIDToken() != null) {
            rt.add(OIDCResponseTypeValue.ID_TOKEN);
        }
        if (this.getAccessToken() != null) {
            rt.add(ResponseType.Value.TOKEN);
        }
        return rt;
    }

    @Override
    public ResponseMode impliedResponseMode() {
        if (this.getResponseMode() != null) {
            return this.getResponseMode();
        }
        if (this.getAccessToken() != null || this.getIDToken() != null) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public JWT getIDToken() {
        return this.idToken;
    }

    public State getSessionState() {
        return this.sessionState;
    }

    @Override
    public Map<String, String> toParameters() {
        Map<String, String> params = super.toParameters();
        if (this.idToken != null) {
            try {
                params.put("id_token", this.idToken.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token: " + e.getMessage(), e);
            }
        }
        if (this.sessionState != null) {
            params.put("session_state", this.sessionState.getValue());
        }
        return params;
    }

    @Override
    public AuthenticationSuccessResponse toSuccessResponse() {
        return this;
    }

    @Override
    public AuthenticationErrorResponse toErrorResponse() {
        throw new ClassCastException("Cannot cast to AuthenticationErrorResponse");
    }

    public static AuthenticationSuccessResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        AuthorizationResponse asr = AuthorizationSuccessResponse.parse(redirectURI, params);
        JWT idToken = null;
        if (params.get("id_token") != null) {
            try {
                idToken = JWTParser.parse((String)params.get("id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid ID Token JWT: " + e.getMessage(), e);
            }
        }
        State sessionState = null;
        if (StringUtils.isNotBlank(params.get("session_state"))) {
            sessionState = new State(params.get("session_state"));
        }
        return new AuthenticationSuccessResponse(redirectURI, ((AuthorizationSuccessResponse)asr).getAuthorizationCode(), idToken, ((AuthorizationSuccessResponse)asr).getAccessToken(), asr.getState(), sessionState, null);
    }

    public static AuthenticationSuccessResponse parse(URI uri) throws ParseException {
        Map<String, String> params;
        if (uri.getRawFragment() != null) {
            params = URLUtils.parseParameters(uri.getRawFragment());
        } else if (uri.getRawQuery() != null) {
            params = URLUtils.parseParameters(uri.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthenticationSuccessResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthenticationSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthenticationSuccessResponse.parse(location);
    }

    public static AuthenticationSuccessResponse parse(HTTPRequest httpRequest) throws ParseException {
        URI baseURI;
        try {
            baseURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (httpRequest.getQuery() != null) {
            return AuthenticationSuccessResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getQuery()));
        }
        if (httpRequest.getFragment() != null) {
            return AuthenticationSuccessResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationSuccessResponse.parse(hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthenticationSuccessResponse.parse(hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AuthorizationSuccessResponse parse(URI uRI) throws ParseException {
        return AuthenticationSuccessResponse.parse(uRI);
    }
}

