/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bsca.v20210811.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeKBVulnerabilityRequest extends AbstractModel {

    /**
    * 根据CVE ID查询（不能与其他参数同时存在）
    */
    @SerializedName("CVEID")
    @Expose
    private String [] CVEID;

    /**
    * 根据Vul ID查询（不能与其他参数同时存在）
    */
    @SerializedName("VulID")
    @Expose
    private String [] VulID;

    /**
    * 根据CNVD ID查询（不能与其他参数同时存在）
    */
    @SerializedName("CNVDID")
    @Expose
    private String [] CNVDID;

    /**
    * 根据CNNVD ID查询（不能与其他参数同时存在）
    */
    @SerializedName("CNNVDID")
    @Expose
    private String [] CNNVDID;

    /**
     * Get 根据CVE ID查询（不能与其他参数同时存在） 
     * @return CVEID 根据CVE ID查询（不能与其他参数同时存在）
     */
    public String [] getCVEID() {
        return this.CVEID;
    }

    /**
     * Set 根据CVE ID查询（不能与其他参数同时存在）
     * @param CVEID 根据CVE ID查询（不能与其他参数同时存在）
     */
    public void setCVEID(String [] CVEID) {
        this.CVEID = CVEID;
    }

    /**
     * Get 根据Vul ID查询（不能与其他参数同时存在） 
     * @return VulID 根据Vul ID查询（不能与其他参数同时存在）
     */
    public String [] getVulID() {
        return this.VulID;
    }

    /**
     * Set 根据Vul ID查询（不能与其他参数同时存在）
     * @param VulID 根据Vul ID查询（不能与其他参数同时存在）
     */
    public void setVulID(String [] VulID) {
        this.VulID = VulID;
    }

    /**
     * Get 根据CNVD ID查询（不能与其他参数同时存在） 
     * @return CNVDID 根据CNVD ID查询（不能与其他参数同时存在）
     */
    public String [] getCNVDID() {
        return this.CNVDID;
    }

    /**
     * Set 根据CNVD ID查询（不能与其他参数同时存在）
     * @param CNVDID 根据CNVD ID查询（不能与其他参数同时存在）
     */
    public void setCNVDID(String [] CNVDID) {
        this.CNVDID = CNVDID;
    }

    /**
     * Get 根据CNNVD ID查询（不能与其他参数同时存在） 
     * @return CNNVDID 根据CNNVD ID查询（不能与其他参数同时存在）
     */
    public String [] getCNNVDID() {
        return this.CNNVDID;
    }

    /**
     * Set 根据CNNVD ID查询（不能与其他参数同时存在）
     * @param CNNVDID 根据CNNVD ID查询（不能与其他参数同时存在）
     */
    public void setCNNVDID(String [] CNNVDID) {
        this.CNNVDID = CNNVDID;
    }

    public DescribeKBVulnerabilityRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeKBVulnerabilityRequest(DescribeKBVulnerabilityRequest source) {
        if (source.CVEID != null) {
            this.CVEID = new String[source.CVEID.length];
            for (int i = 0; i < source.CVEID.length; i++) {
                this.CVEID[i] = new String(source.CVEID[i]);
            }
        }
        if (source.VulID != null) {
            this.VulID = new String[source.VulID.length];
            for (int i = 0; i < source.VulID.length; i++) {
                this.VulID[i] = new String(source.VulID[i]);
            }
        }
        if (source.CNVDID != null) {
            this.CNVDID = new String[source.CNVDID.length];
            for (int i = 0; i < source.CNVDID.length; i++) {
                this.CNVDID[i] = new String(source.CNVDID[i]);
            }
        }
        if (source.CNNVDID != null) {
            this.CNNVDID = new String[source.CNNVDID.length];
            for (int i = 0; i < source.CNNVDID.length; i++) {
                this.CNNVDID[i] = new String(source.CNNVDID[i]);
            }
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "CVEID.", this.CVEID);
        this.setParamArraySimple(map, prefix + "VulID.", this.VulID);
        this.setParamArraySimple(map, prefix + "CNVDID.", this.CNVDID);
        this.setParamArraySimple(map, prefix + "CNNVDID.", this.CNNVDID);

    }
}

