/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class CreateMalwareWhiteListRequest extends AbstractModel {

    /**
    * 白名单模式； 0MD5白名单，1自定义
    */
    @SerializedName("Mode")
    @Expose
    private Long Mode;

    /**
    * quuid 列表
    */
    @SerializedName("QuuidList")
    @Expose
    private String [] QuuidList;

    /**
    * 是否全部主机； 0否，1是。
    */
    @SerializedName("IsGlobal")
    @Expose
    private Long IsGlobal;

    /**
    * 匹配模式 ；0 精确匹配，1模糊匹配（废弃）
    */
    @SerializedName("MatchType")
    @Expose
    private Long MatchType;

    /**
    * 文件名称(正则)；长度不超过200个
    */
    @SerializedName("FileName")
    @Expose
    private String [] FileName;

    /**
    * 文件目录(正则)；长度不超过200个,内容base64转义
    */
    @SerializedName("FileDirectory")
    @Expose
    private String [] FileDirectory;

    /**
    * 文件后缀；长度不超过200个,内容base64转义（废弃）
    */
    @SerializedName("FileExtension")
    @Expose
    private String [] FileExtension;

    /**
    * MD5列表
    */
    @SerializedName("Md5List")
    @Expose
    private String [] Md5List;

    /**
    * 木马事件ID
    */
    @SerializedName("EventId")
    @Expose
    private Long EventId;

    /**
     * Get 白名单模式； 0MD5白名单，1自定义 
     * @return Mode 白名单模式； 0MD5白名单，1自定义
     */
    public Long getMode() {
        return this.Mode;
    }

    /**
     * Set 白名单模式； 0MD5白名单，1自定义
     * @param Mode 白名单模式； 0MD5白名单，1自定义
     */
    public void setMode(Long Mode) {
        this.Mode = Mode;
    }

    /**
     * Get quuid 列表 
     * @return QuuidList quuid 列表
     */
    public String [] getQuuidList() {
        return this.QuuidList;
    }

    /**
     * Set quuid 列表
     * @param QuuidList quuid 列表
     */
    public void setQuuidList(String [] QuuidList) {
        this.QuuidList = QuuidList;
    }

    /**
     * Get 是否全部主机； 0否，1是。 
     * @return IsGlobal 是否全部主机； 0否，1是。
     */
    public Long getIsGlobal() {
        return this.IsGlobal;
    }

    /**
     * Set 是否全部主机； 0否，1是。
     * @param IsGlobal 是否全部主机； 0否，1是。
     */
    public void setIsGlobal(Long IsGlobal) {
        this.IsGlobal = IsGlobal;
    }

    /**
     * Get 匹配模式 ；0 精确匹配，1模糊匹配（废弃） 
     * @return MatchType 匹配模式 ；0 精确匹配，1模糊匹配（废弃）
     */
    public Long getMatchType() {
        return this.MatchType;
    }

    /**
     * Set 匹配模式 ；0 精确匹配，1模糊匹配（废弃）
     * @param MatchType 匹配模式 ；0 精确匹配，1模糊匹配（废弃）
     */
    public void setMatchType(Long MatchType) {
        this.MatchType = MatchType;
    }

    /**
     * Get 文件名称(正则)；长度不超过200个 
     * @return FileName 文件名称(正则)；长度不超过200个
     */
    public String [] getFileName() {
        return this.FileName;
    }

    /**
     * Set 文件名称(正则)；长度不超过200个
     * @param FileName 文件名称(正则)；长度不超过200个
     */
    public void setFileName(String [] FileName) {
        this.FileName = FileName;
    }

    /**
     * Get 文件目录(正则)；长度不超过200个,内容base64转义 
     * @return FileDirectory 文件目录(正则)；长度不超过200个,内容base64转义
     */
    public String [] getFileDirectory() {
        return this.FileDirectory;
    }

    /**
     * Set 文件目录(正则)；长度不超过200个,内容base64转义
     * @param FileDirectory 文件目录(正则)；长度不超过200个,内容base64转义
     */
    public void setFileDirectory(String [] FileDirectory) {
        this.FileDirectory = FileDirectory;
    }

    /**
     * Get 文件后缀；长度不超过200个,内容base64转义（废弃） 
     * @return FileExtension 文件后缀；长度不超过200个,内容base64转义（废弃）
     */
    public String [] getFileExtension() {
        return this.FileExtension;
    }

    /**
     * Set 文件后缀；长度不超过200个,内容base64转义（废弃）
     * @param FileExtension 文件后缀；长度不超过200个,内容base64转义（废弃）
     */
    public void setFileExtension(String [] FileExtension) {
        this.FileExtension = FileExtension;
    }

    /**
     * Get MD5列表 
     * @return Md5List MD5列表
     */
    public String [] getMd5List() {
        return this.Md5List;
    }

    /**
     * Set MD5列表
     * @param Md5List MD5列表
     */
    public void setMd5List(String [] Md5List) {
        this.Md5List = Md5List;
    }

    /**
     * Get 木马事件ID 
     * @return EventId 木马事件ID
     */
    public Long getEventId() {
        return this.EventId;
    }

    /**
     * Set 木马事件ID
     * @param EventId 木马事件ID
     */
    public void setEventId(Long EventId) {
        this.EventId = EventId;
    }

    public CreateMalwareWhiteListRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public CreateMalwareWhiteListRequest(CreateMalwareWhiteListRequest source) {
        if (source.Mode != null) {
            this.Mode = new Long(source.Mode);
        }
        if (source.QuuidList != null) {
            this.QuuidList = new String[source.QuuidList.length];
            for (int i = 0; i < source.QuuidList.length; i++) {
                this.QuuidList[i] = new String(source.QuuidList[i]);
            }
        }
        if (source.IsGlobal != null) {
            this.IsGlobal = new Long(source.IsGlobal);
        }
        if (source.MatchType != null) {
            this.MatchType = new Long(source.MatchType);
        }
        if (source.FileName != null) {
            this.FileName = new String[source.FileName.length];
            for (int i = 0; i < source.FileName.length; i++) {
                this.FileName[i] = new String(source.FileName[i]);
            }
        }
        if (source.FileDirectory != null) {
            this.FileDirectory = new String[source.FileDirectory.length];
            for (int i = 0; i < source.FileDirectory.length; i++) {
                this.FileDirectory[i] = new String(source.FileDirectory[i]);
            }
        }
        if (source.FileExtension != null) {
            this.FileExtension = new String[source.FileExtension.length];
            for (int i = 0; i < source.FileExtension.length; i++) {
                this.FileExtension[i] = new String(source.FileExtension[i]);
            }
        }
        if (source.Md5List != null) {
            this.Md5List = new String[source.Md5List.length];
            for (int i = 0; i < source.Md5List.length; i++) {
                this.Md5List[i] = new String(source.Md5List[i]);
            }
        }
        if (source.EventId != null) {
            this.EventId = new Long(source.EventId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Mode", this.Mode);
        this.setParamArraySimple(map, prefix + "QuuidList.", this.QuuidList);
        this.setParamSimple(map, prefix + "IsGlobal", this.IsGlobal);
        this.setParamSimple(map, prefix + "MatchType", this.MatchType);
        this.setParamArraySimple(map, prefix + "FileName.", this.FileName);
        this.setParamArraySimple(map, prefix + "FileDirectory.", this.FileDirectory);
        this.setParamArraySimple(map, prefix + "FileExtension.", this.FileExtension);
        this.setParamArraySimple(map, prefix + "Md5List.", this.Md5List);
        this.setParamSimple(map, prefix + "EventId", this.EventId);

    }
}

