/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ScanBaselineResponse extends AbstractModel {

    /**
    * 正在扫描中的主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("ScanningQuuids")
    @Expose
    private String [] ScanningQuuids;

    /**
    * 任务下发成功返回的TaskId
注意：此字段可能返回 null，表示取不到有效值。
    */
    @SerializedName("TaskId")
    @Expose
    private Long TaskId;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 正在扫描中的主机Quuid
注意：此字段可能返回 null，表示取不到有效值。 
     * @return ScanningQuuids 正在扫描中的主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public String [] getScanningQuuids() {
        return this.ScanningQuuids;
    }

    /**
     * Set 正在扫描中的主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
     * @param ScanningQuuids 正在扫描中的主机Quuid
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setScanningQuuids(String [] ScanningQuuids) {
        this.ScanningQuuids = ScanningQuuids;
    }

    /**
     * Get 任务下发成功返回的TaskId
注意：此字段可能返回 null，表示取不到有效值。 
     * @return TaskId 任务下发成功返回的TaskId
注意：此字段可能返回 null，表示取不到有效值。
     */
    public Long getTaskId() {
        return this.TaskId;
    }

    /**
     * Set 任务下发成功返回的TaskId
注意：此字段可能返回 null，表示取不到有效值。
     * @param TaskId 任务下发成功返回的TaskId
注意：此字段可能返回 null，表示取不到有效值。
     */
    public void setTaskId(Long TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public ScanBaselineResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public ScanBaselineResponse(ScanBaselineResponse source) {
        if (source.ScanningQuuids != null) {
            this.ScanningQuuids = new String[source.ScanningQuuids.length];
            for (int i = 0; i < source.ScanningQuuids.length; i++) {
                this.ScanningQuuids[i] = new String(source.ScanningQuuids[i]);
            }
        }
        if (source.TaskId != null) {
            this.TaskId = new Long(source.TaskId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArraySimple(map, prefix + "ScanningQuuids.", this.ScanningQuuids);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

