/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.dlc.v20210125.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeDataEnginePythonSparkImagesResponse extends AbstractModel {

    /**
    * PYSPARK镜像信息列表
    */
    @SerializedName("PythonSparkImages")
    @Expose
    private PythonSparkImage [] PythonSparkImages;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get PYSPARK镜像信息列表 
     * @return PythonSparkImages PYSPARK镜像信息列表
     */
    public PythonSparkImage [] getPythonSparkImages() {
        return this.PythonSparkImages;
    }

    /**
     * Set PYSPARK镜像信息列表
     * @param PythonSparkImages PYSPARK镜像信息列表
     */
    public void setPythonSparkImages(PythonSparkImage [] PythonSparkImages) {
        this.PythonSparkImages = PythonSparkImages;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeDataEnginePythonSparkImagesResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeDataEnginePythonSparkImagesResponse(DescribeDataEnginePythonSparkImagesResponse source) {
        if (source.PythonSparkImages != null) {
            this.PythonSparkImages = new PythonSparkImage[source.PythonSparkImages.length];
            for (int i = 0; i < source.PythonSparkImages.length; i++) {
                this.PythonSparkImages[i] = new PythonSparkImage(source.PythonSparkImages[i]);
            }
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamArrayObj(map, prefix + "PythonSparkImages.", this.PythonSparkImages);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

