/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum DraftBeheraLDAPPasswordPolicy10WarningType {
    TIME_BEFORE_EXPIRATION("time before expiration"),
    GRACE_LOGINS_REMAINING("grace logins remaining");

    private final String name;

    private DraftBeheraLDAPPasswordPolicy10WarningType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static DraftBeheraLDAPPasswordPolicy10WarningType forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "timebeforeexpiration": 
            case "time-before-expiration": 
            case "time_before_expiration": 
            case "time before expiration": {
                return TIME_BEFORE_EXPIRATION;
            }
            case "graceloginsremaining": 
            case "grace-logins-remaining": 
            case "grace_logins_remaining": 
            case "grace logins remaining": {
                return GRACE_LOGINS_REMAINING;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

