/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.params.SearchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Search
extends AbstractAction<SearchResult> {
    private String query;
    private List<Sort> sortList = new LinkedList<Sort>();
    protected List<String> includePatternList = new ArrayList<String>();
    protected List<String> excludePatternList = new ArrayList<String>();

    protected Search(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.sortList = builder.sortList;
        this.includePatternList = builder.includePatternList;
        this.excludePatternList = builder.excludePatternList;
        this.setURI(this.buildURI());
    }

    protected Search(TemplateBuilder templatedBuilder) {
        super(templatedBuilder);
        this.query = templatedBuilder.query;
        this.sortList = templatedBuilder.sortList;
        this.includePatternList = templatedBuilder.includePatternList;
        this.excludePatternList = templatedBuilder.excludePatternList;
        this.setURI(this.buildURI() + "/template");
    }

    @Override
    public SearchResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, Gson gson) {
        return this.createNewElasticSearchResult(new SearchResult(gson), responseBody, statusCode, reasonPhrase, gson);
    }

    public String getIndex() {
        return this.indexName;
    }

    public String getType() {
        return this.typeName;
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_search";
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(Gson gson) {
        String data;
        if (this.sortList.isEmpty() && this.includePatternList.isEmpty() && this.excludePatternList.isEmpty()) {
            data = this.query;
        } else {
            JsonObject queryObject = (JsonObject)gson.fromJson(this.query, JsonObject.class);
            if (queryObject == null) {
                queryObject = new JsonObject();
            }
            if (!this.sortList.isEmpty()) {
                JsonArray sortArray = Search.normalizeSortClause(queryObject);
                for (Sort sort : this.sortList) {
                    sortArray.add((JsonElement)sort.toJsonObject());
                }
            }
            if (!this.includePatternList.isEmpty() || !this.excludePatternList.isEmpty()) {
                JsonObject sourceObject = Search.normalizeSourceClause(queryObject);
                Search.addPatternListToSource(sourceObject, "include", this.includePatternList);
                Search.addPatternListToSource(sourceObject, "exclude", this.excludePatternList);
            }
            data = gson.toJson((JsonElement)queryObject);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JsonArray normalizeSortClause(JsonObject queryObject) {
        JsonArray sortArray;
        if (queryObject.has("sort")) {
            JsonElement sortElement = queryObject.get("sort");
            if (sortElement.isJsonArray()) {
                sortArray = sortElement.getAsJsonArray();
            } else if (sortElement.isJsonObject()) {
                sortArray = new JsonArray();
                sortArray.add((JsonElement)sortElement.getAsJsonObject());
            } else {
                if (!sortElement.isJsonPrimitive() || !sortElement.getAsJsonPrimitive().isString()) throw new JsonSyntaxException("_source must be an array, an object or a string");
                String sortField = sortElement.getAsString();
                sortArray = new JsonArray();
                queryObject.add("sort", (JsonElement)sortArray);
                String order = "_score".equals(sortField) ? "desc" : "asc";
                JsonObject sortOrder = new JsonObject();
                sortOrder.add("order", (JsonElement)new JsonPrimitive(order));
                JsonObject sortDefinition = new JsonObject();
                sortDefinition.add(sortField, (JsonElement)sortOrder);
                sortArray.add((JsonElement)sortDefinition);
            }
        } else {
            sortArray = new JsonArray();
        }
        queryObject.add("sort", (JsonElement)sortArray);
        return sortArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JsonObject normalizeSourceClause(JsonObject queryObject) {
        JsonObject sourceObject;
        if (queryObject.has("_source")) {
            JsonElement sourceElement = queryObject.get("_source");
            if (sourceElement.isJsonObject()) {
                sourceObject = sourceElement.getAsJsonObject();
            } else if (sourceElement.isJsonArray()) {
                sourceObject = new JsonObject();
                queryObject.add("_source", (JsonElement)sourceObject);
                sourceObject.add("include", (JsonElement)sourceElement.getAsJsonArray());
            } else {
                if (!sourceElement.isJsonPrimitive() || !sourceElement.getAsJsonPrimitive().isBoolean()) throw new JsonSyntaxException("_source must be an object, an array or a boolean");
                sourceObject = new JsonObject();
            }
        } else {
            sourceObject = new JsonObject();
        }
        queryObject.add("_source", (JsonElement)sourceObject);
        return sourceObject;
    }

    private static void addPatternListToSource(JsonObject sourceObject, String rule, List<String> patternList) {
        if (!patternList.isEmpty()) {
            JsonArray ruleArray;
            if (sourceObject.has(rule)) {
                ruleArray = sourceObject.get(rule).getAsJsonArray();
            } else {
                ruleArray = new JsonArray();
                sourceObject.add(rule, (JsonElement)ruleArray);
            }
            for (String pattern : patternList) {
                ruleArray.add(pattern);
            }
        }
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.query).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Search rhs = (Search)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.query, (Object)rhs.query).append(this.sortList, rhs.sortList).append(this.includePatternList, rhs.includePatternList).append(this.excludePatternList, rhs.excludePatternList).isEquals();
    }

    public static class TemplateBuilder
    extends Builder {
        public TemplateBuilder(String templatedQuery) {
            super(templatedQuery);
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }

    public static class VersionBuilder
    extends Builder {
        public VersionBuilder(String query) {
            super(query);
            this.setParameter("version", "true");
        }
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<Search, Builder> {
        protected String query;
        protected List<Sort> sortList = new LinkedList<Sort>();
        protected List<String> includePatternList = new ArrayList<String>();
        protected List<String> excludePatternList = new ArrayList<String>();

        public Builder(String query) {
            this.query = query;
        }

        public Builder setSearchType(SearchType searchType) {
            return (Builder)this.setParameter("search_type", (Object)searchType);
        }

        public Builder addSort(Sort sort) {
            this.sortList.add(sort);
            return this;
        }

        public Builder addSourceExcludePattern(String excludePattern) {
            this.excludePatternList.add(excludePattern);
            return this;
        }

        public Builder addSourceIncludePattern(String includePattern) {
            this.includePatternList.add(includePattern);
            return this;
        }

        public Builder addSort(Collection<Sort> sorts) {
            this.sortList.addAll(sorts);
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

