/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SignificantTermsAggregation
extends BucketAggregation {
    public static final String TYPE = "significant_terms";
    private Long totalCount;
    private List<SignificantTerm> significantTerms = new LinkedList<SignificantTerm>();

    public SignificantTermsAggregation(String name, JsonObject significantTermsAggregation) {
        super(name, significantTermsAggregation);
        if (significantTermsAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && significantTermsAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(significantTermsAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
        if (significantTermsAggregation.has(String.valueOf((Object)AggregationField.DOC_COUNT))) {
            this.totalCount = significantTermsAggregation.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong();
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketv : bucketsSource) {
            JsonObject bucket = bucketv.getAsJsonObject();
            SignificantTerm term = new SignificantTerm(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsString(), bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong(), bucket.get(String.valueOf((Object)AggregationField.SCORE)).getAsDouble(), bucket.get(String.valueOf((Object)AggregationField.BG_COUNT)).getAsLong());
            this.significantTerms.add(term);
        }
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<SignificantTerm> getBuckets() {
        return this.significantTerms;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SignificantTermsAggregation rhs = (SignificantTermsAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.totalCount, (Object)rhs.totalCount).append(this.significantTerms, rhs.significantTerms).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.totalCount).append(this.significantTerms).toHashCode();
    }

    public class SignificantTerm
    extends Bucket {
        private String key;
        private Double score;
        private Long backgroundCount;

        public SignificantTerm(JsonObject bucket, String key, Long count, Double score, Long backgroundCount) {
            super(bucket, count);
            this.key = key;
            this.score = score;
            this.backgroundCount = backgroundCount;
        }

        public String getKey() {
            return this.key;
        }

        public Double getScore() {
            return this.score;
        }

        public Long getBackgroundCount() {
            return this.backgroundCount;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SignificantTerm rhs = (SignificantTerm)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.key, (Object)rhs.key).append((Object)this.score, (Object)rhs.score).append((Object)this.backgroundCount, (Object)rhs.backgroundCount).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.backgroundCount).append((Object)this.key).append((Object)this.score).toHashCode();
        }
    }
}

