/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import com.opensymphony.webwork.dispatcher.client.ProgressConsumer;
import com.opensymphony.webwork.dispatcher.client.ProgressNotification;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;

public class ProgressInputStream
extends FilterInputStream {
    private ProgressConsumer progressConsumer;
    private ProgressNotification notification;
    private int lastNotificationStatus;
    private int nread = 0;
    private int size = 0;
    private long lastUpdate;
    private long updateFrequency;

    public ProgressInputStream(ProgressNotification notification, ProgressConsumer progressConsumer, Properties props, InputStream in, int contentLength) {
        super(in);
        this.size = contentLength;
        this.notification = notification;
        this.progressConsumer = progressConsumer;
        this.lastUpdate = new Date().getTime();
        this.lastNotificationStatus = notification.getStatus();
        notification.setInputSize(this.size);
        try {
            this.updateFrequency = new Long(props.getProperty("updateFrequency", "250"));
        }
        catch (NumberFormatException nfe) {
            this.updateFrequency = 500L;
        }
        try {
            notification.setStatus(4);
        }
        catch (ClientException ignored) {
            // empty catch block
        }
        this.updateBytes(this.nread);
    }

    public void close() throws IOException {
        this.updateBytes(this.nread);
        this.in.close();
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            ++this.nread;
            this.updateBytes(this.nread);
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        if (nr > 0) {
            this.nread += nr;
            this.updateBytes(this.nread);
        }
        return nr;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        if (nr > 0) {
            this.nread += nr;
            this.updateBytes(this.nread);
        }
        return nr;
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread = this.size - this.in.available();
        this.updateBytes(this.nread);
    }

    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        if (nr > 0L) {
            this.nread = (int)((long)this.nread + nr);
            this.updateBytes(this.nread);
        }
        return nr;
    }

    private void updateBytes(int nowRead) {
        boolean update = false;
        if (nowRead >= this.size && this.notification.getStatus() == 4) {
            try {
                this.notification.setStatus(5);
            }
            catch (ClientException ignored) {
                // empty catch block
            }
        }
        if (this.lastNotificationStatus != this.notification.getStatus()) {
            update = true;
        }
        long currentTime = new Date().getTime();
        if (this.notification.getStatus() == 4 && currentTime > this.lastUpdate + this.updateFrequency) {
            update = true;
        }
        if (update) {
            this.lastUpdate = currentTime;
            this.lastNotificationStatus = this.notification.getStatus();
            this.notification.setInputReceived(nowRead);
            this.progressConsumer.notify(this.notification);
        }
    }
}

