/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.api;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.ShouldThrowException;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class DeploymentConfiguration {
    private TargetsContainer targetsContainer;
    private OverProtocol overProtocol;
    private ShouldThrowException shouldThrowException;
    private Archive archive;
    private Descriptor descriptor;
    private Deployment deployment = new DeploymentClass();

    public TargetsContainer getTargets() {
        return this.targetsContainer;
    }

    public OverProtocol getOverProtocol() {
        return this.overProtocol;
    }

    public ShouldThrowException getShouldThrowException() {
        return this.shouldThrowException;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DeploymentClass
    implements Deployment {
        private String name = "_DEFAULT_";
        private boolean managed = true;
        private int order = -1;
        private boolean testable = true;

        DeploymentClass() {
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        void setManaged(boolean managed) {
            this.managed = managed;
        }

        @Override
        public boolean managed() {
            return this.managed;
        }

        void setOrder(int order) {
            this.order = order;
        }

        @Override
        public int order() {
            return this.order;
        }

        void setTestable(boolean testable) {
            this.testable = testable;
        }

        @Override
        public boolean testable() {
            return this.testable;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Deployment.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TargetsContainerClass
    implements TargetsContainer {
        private final String value;

        TargetsContainerClass(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return TargetsContainerClass.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverProtocolClass
    implements OverProtocol {
        private final String overProtocol;

        OverProtocolClass(String overProtocol) {
            this.overProtocol = overProtocol;
        }

        @Override
        public String value() {
            return this.overProtocol;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return OverProtocol.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShouldThrowExceptionClass
    implements ShouldThrowException {
        private Class<? extends Exception> exception;
        private boolean testable;

        ShouldThrowExceptionClass(Class<? extends Exception> exception, boolean testable) {
            this.exception = exception;
            this.testable = testable;
        }

        @Override
        public Class<? extends Exception> value() {
            return this.exception;
        }

        public void setException(Class<? extends Exception> exception) {
            this.exception = exception;
        }

        @Override
        public boolean testable() {
            return this.testable;
        }

        public void setTestable(boolean testable) {
            this.testable = testable;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ShouldThrowException.class;
        }
    }

    public static class DeploymentBuilder {
        private final DeploymentContentBuilder deploymentContentBuilder;
        private final DeploymentClass deploymentClass = new DeploymentClass();

        DeploymentBuilder(DeploymentContentBuilder deploymentContentBuilder) {
            this.deploymentContentBuilder = deploymentContentBuilder;
        }

        public DeploymentBuilder withTestable(boolean testable) {
            this.deploymentClass.setTestable(testable);
            return this;
        }

        public DeploymentBuilder withOrder(int order) {
            this.deploymentClass.setOrder(order);
            return this;
        }

        public DeploymentBuilder withManaged(boolean managed) {
            this.deploymentClass.setManaged(managed);
            return this;
        }

        public DeploymentBuilder withName(String name) {
            this.deploymentClass.setName(name);
            return this;
        }

        public DeploymentContentBuilder build() {
            this.deploymentContentBuilder.deploymentConfiguration.deployment = this.deploymentClass;
            return this.deploymentContentBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeploymentContentBuilder {
        final DeploymentConfiguration deploymentConfiguration = new DeploymentConfiguration();

        public DeploymentContentBuilder(Archive<?> archive) {
            this.deploymentConfiguration.archive = archive;
        }

        public DeploymentContentBuilder(Descriptor descriptor) {
            this.deploymentConfiguration.descriptor = descriptor;
        }

        public DeploymentContentBuilder withTargetsContainer(String targetsContainer) {
            this.deploymentConfiguration.targetsContainer = new TargetsContainerClass(targetsContainer);
            return this;
        }

        public DeploymentContentBuilder withOverProtocol(String overProtocol) {
            this.deploymentConfiguration.overProtocol = new OverProtocolClass(overProtocol);
            return this;
        }

        public DeploymentContentBuilder withShouldThrowException(Class<? extends Exception> exception, boolean testeable) {
            this.deploymentConfiguration.shouldThrowException = new ShouldThrowExceptionClass(exception, testeable);
            return this;
        }

        public DeploymentContentBuilder withShouldThrowException(Class<? extends Exception> exception) {
            this.deploymentConfiguration.shouldThrowException = new ShouldThrowExceptionClass(exception, false);
            return this;
        }

        public DeploymentBuilder withDeployment() {
            return new DeploymentBuilder(this);
        }

        public DeploymentConfiguration get() {
            return this.deploymentConfiguration;
        }
    }
}

