/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.ReplaceThisByStaticReference;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonObjectJvmStaticLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "functionsMadeStatic", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getFunctionsMadeStatic", "()Ljava/util/Set;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "modifyBody", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "oldDispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend"})
final class SingletonObjectJvmStaticLowering
implements ClassLoweringPass {
    @NotNull
    private final Set<IrFunctionSymbol> functionsMadeStatic;
    @NotNull
    private final JvmBackendContext context;

    @NotNull
    public final Set<IrFunctionSymbol> getFunctionsMadeStatic() {
        return this.functionsMadeStatic;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isObject(irClass) || irClass.isCompanion()) {
            return;
        }
        Iterable $receiver$iv = irClass.getDeclarations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IrDeclaration p1 = (IrDeclaration)element$iv$iv;
            if (!JvmStaticAnnotationLoweringKt.access$isJvmStaticFunction(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            IrValueParameter oldDispatchReceiverParemeter;
            IrDeclaration it;
            IrDeclaration irDeclaration = it = (IrDeclaration)element$iv;
            if (irDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrSimpleFunction jvmStaticFunction = (IrSimpleFunction)irDeclaration;
            if (jvmStaticFunction.getDispatchReceiverParameter() == null) {
                Intrinsics.throwNpe();
            }
            jvmStaticFunction.setDispatchReceiverParameter(null);
            this.modifyBody(jvmStaticFunction, irClass, oldDispatchReceiverParemeter);
            this.functionsMadeStatic.add(jvmStaticFunction.getSymbol());
        }
    }

    public final void modifyBody(@NotNull IrFunction irFunction, @NotNull IrClass irClass, @NotNull IrValueParameter oldDispatchReceiverParameter) {
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull((Object)oldDispatchReceiverParameter, (String)"oldDispatchReceiverParameter");
        IrBody irBody = irFunction.getBody();
        irFunction.setBody(irBody != null ? irBody.transform(new ReplaceThisByStaticReference(this.context, irClass, oldDispatchReceiverParameter), null) : null);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public SingletonObjectJvmStaticLowering(@NotNull JvmBackendContext context) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        SingletonObjectJvmStaticLowering singletonObjectJvmStaticLowering = this;
        singletonObjectJvmStaticLowering.functionsMadeStatic = set = (Set)new LinkedHashSet();
    }
}

