/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstances", "", "project", "Lcom/intellij/openapi/project/Project;", "registerExtension", "", "extension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "registerExtensionPoint", "frontend"})
public class ProjectExtensionDescriptor<T> {
    @NotNull
    private final ExtensionPointName<T> extensionPointName;
    private final Class<T> extensionClass;

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Extensions.getArea(project).registerExtensionPoint(this.extensionPointName.getName(), this.extensionClass.getName(), ExtensionPoint.Kind.INTERFACE);
    }

    public final void registerExtension(@NotNull Project project, T extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Extensions.getArea(project).getExtensionPoint(this.extensionPointName).registerExtension(extension);
    }

    @NotNull
    public final List<T> getInstances(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ExtensionsArea projectArea = Extensions.getArea(project);
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        ExtensionPoint<T> extensionPoint = projectArea.getExtensionPoint(this.extensionPointName);
        Intrinsics.checkExpressionValueIsNotNull(extensionPoint, (String)"projectArea.getExtensionPoint(extensionPointName)");
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"projectArea.getExtension\u2026sionPointName).extensions");
        return ArraysKt.toList((Object[])objectArray);
    }

    public ProjectExtensionDescriptor(@NotNull String name, @NotNull Class<T> extensionClass) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(extensionClass, (String)"extensionClass");
        this.extensionClass = extensionClass;
        ExtensionPointName extensionPointName = ExtensionPointName.create(name);
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"ExtensionPointName.create(name)");
        this.extensionPointName = extensionPointName;
    }
}

