/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UnderscoreUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallElement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "checkSimpleNameUsage", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "isUnderscoreOnlyName", "", "", "frontend"})
public final class UnderscoreUsageChecker
implements CallChecker {
    public static final UnderscoreUsageChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        DeclarationDescriptor declarationDescriptor;
        Substitutable<CallableDescriptor> substitutable;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return;
        }
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        Object obj = descriptor2;
        if (!(obj instanceof ConstructorDescriptor)) {
            obj = null;
        }
        if ((substitutable = (ConstructorDescriptor)obj) != null && (substitutable = substitutable.getContainingDeclaration()) != null) {
            declarationDescriptor = substitutable;
        } else {
            Object obj2 = descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"descriptor");
            declarationDescriptor = (DeclarationDescriptor)obj2;
        }
        DeclarationDescriptor namedDescriptor = declarationDescriptor;
        String string = namedDescriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"namedDescriptor.name.asString()");
        if (!this.isUnderscoreOnlyName(string)) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
        this.checkCallElement(ktElement, context);
    }

    private final void checkCallElement(KtElement ktElement, CallCheckerContext context) {
        block2: {
            KtElement ktElement2;
            block1: {
                ktElement2 = ktElement;
                if (!(ktElement2 instanceof KtSimpleNameExpression)) break block1;
                this.checkSimpleNameUsage((KtSimpleNameExpression)ktElement, context.getTrace());
                break block2;
            }
            if (!(ktElement2 instanceof KtCallExpression)) break block2;
            KtExpression ktExpression = ((KtCallExpression)ktElement).getCalleeExpression();
            if (ktExpression != null) {
                KtExpression ktExpression2;
                KtExpression it;
                KtExpression ktExpression3 = it = (ktExpression2 = ktExpression);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"it");
                INSTANCE.checkCallElement(ktExpression3, context);
            }
        }
    }

    private final void checkSimpleNameUsage(KtSimpleNameExpression ktName, BindingTrace trace) {
        String string = ktName.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ktName.text");
        if (this.isUnderscoreOnlyName(string)) {
            trace.report(Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.on(ktName));
        }
    }

    public final void checkSimpleNameUsage(@NotNull DeclarationDescriptor descriptor2, @NotNull KtSimpleNameExpression ktName, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)ktName, (String)"ktName");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
        if (this.isUnderscoreOnlyName(string)) {
            this.checkSimpleNameUsage(ktName, trace);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnderscoreOnlyName(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        if (charSequence.length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $receiver$iv = $receiver;
        CharSequence charSequence2 = $receiver$iv;
        int n = 0;
        while (n < charSequence2.length()) {
            char element$iv = charSequence2.charAt(n);
            char it = element$iv;
            if (it != '_') return false;
            boolean bl2 = true;
            if (!bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private UnderscoreUsageChecker() {
    }

    static {
        UnderscoreUsageChecker underscoreUsageChecker;
        INSTANCE = underscoreUsageChecker = new UnderscoreUsageChecker();
    }
}

