/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.classloader;

import java.io.Serializable;
import org.springframework.util.Assert;

public class ClassLoaderFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Kind kind;
    private final byte[] contents;
    private final long lastModified;

    public ClassLoaderFile(Kind kind, byte[] contents) {
        this(kind, System.currentTimeMillis(), contents);
    }

    public ClassLoaderFile(Kind kind, long lastModified, byte[] contents) {
        Assert.notNull((Object)((Object)kind), (String)"Kind must not be null");
        Assert.isTrue((boolean)(kind != Kind.DELETED ? contents != null : contents == null), (String)("Contents must " + (kind != Kind.DELETED ? "not " : "") + "be null"));
        this.kind = kind;
        this.lastModified = lastModified;
        this.contents = contents;
    }

    public Kind getKind() {
        return this.kind;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public static enum Kind {
        ADDED,
        MODIFIED,
        DELETED;

    }
}

