/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public abstract class Resource
implements Comparable {
    private final Session session;
    private final ResourceURI uri;

    public Resource(Session session, ResourceURI uri) {
        this.session = session;
        this.uri = uri;
    }

    public final Session getSession() {
        return this.session;
    }

    public final ResourceURI getURI() {
        return this.uri;
    }

    public abstract Resource getRelatedResource(String var1);

    public String getContentType() {
        return null;
    }

    public String getCharset() {
        return null;
    }

    public abstract byte[] getContent();

    public abstract InputStream getInputStream();

    public abstract OutputStream getOutputStream();

    public abstract boolean isDirectory();

    public abstract List list();

    public int compareTo(Object other) {
        if (other instanceof Resource) {
            int otherType;
            Resource otherResource = (Resource)other;
            int type = this.isDirectory() ? 0 : 1;
            int n = otherType = otherResource.isDirectory() ? 0 : 1;
            if (type != otherType) {
                return type - otherType;
            }
            return this.uri.getName().compareTo(otherResource.uri.getName());
        }
        return -1;
    }

    protected void assertFile() {
        if (this.isDirectory()) {
            throw new ConfigException("Resource is not a file: " + this.getURI());
        }
    }

    protected void assertDirectory() {
        if (!this.isDirectory()) {
            throw new ConfigException("Resource is not a directory: " + this.getURI());
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

