/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.ssh;

import com.alibaba.antx.config.ConfigException;
import com.alibaba.antx.config.resource.AuthenticationHandler;
import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.ResourceNotFoundException;
import com.alibaba.antx.config.resource.ResourceURI;
import com.alibaba.antx.config.resource.Session;
import com.alibaba.antx.config.resource.ssh.SshResource;
import com.alibaba.antx.config.resource.ssh.SshResourceDriver;
import com.alibaba.antx.config.resource.util.ResourceContext;
import com.alibaba.antx.config.resource.util.ResourceKey;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SshSession
extends Session {
    private final JSch jsch = new JSch();
    private final Map channels = Collections.synchronizedMap(new HashMap());

    public SshSession(SshResourceDriver driver) {
        super(driver);
    }

    public boolean acceptOption(String optionName) {
        return "charset".equals(optionName);
    }

    public Resource getResource(ResourceURI uri) {
        try {
            SftpATTRS stat;
            ChannelSftp channel = this.getOrCreateChannel(uri);
            try {
                stat = channel.stat(uri.getPath());
            }
            catch (SftpException e) {
                throw new ResourceNotFoundException(e);
            }
            return new SshResource(this, channel, uri, stat);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelSftp getOrCreateChannel(ResourceURI uri) {
        ChannelSftp channel;
        final ResourceKey key = new ResourceKey(uri);
        Map map = this.channels;
        synchronized (map) {
            channel = (ChannelSftp)this.channels.get(key);
            if (channel == null) {
                try {
                    try {
                        ResourceContext.get().setCurrentURI(uri.getURI());
                        com.jcraft.jsch.Session session = this.jsch.getSession(key.getUser(), key.getHost(), key.getPort());
                        session.setUserInfo(new UserInfo(){
                            private AuthenticationHandler.UsernamePassword up;

                            public String getPassphrase() {
                                return null;
                            }

                            public boolean promptPassphrase(String message) {
                                return true;
                            }

                            public String getPassword() {
                                return this.up == null ? null : this.up.getPassword();
                            }

                            public boolean promptPassword(String message) {
                                URI uri = ResourceContext.get().getCurrentURI();
                                String username = ResourceContext.get().getCurrentUsername();
                                Set visitedURIs = ResourceContext.get().getVisitedURIs();
                                message = "\nAuthentication required: \n" + uri + "\n";
                                this.up = SshSession.this.getResourceManager().getAuthenticationHandler().authenticate(message, uri, username, visitedURIs.contains(key));
                                visitedURIs.add(key);
                                return this.up != null;
                            }

                            public boolean promptYesNo(String str) {
                                return true;
                            }

                            public void showMessage(String message) {
                            }
                        });
                        session.connect();
                        channel = (ChannelSftp)session.openChannel("sftp");
                        channel.connect();
                        String charset = uri.getOption("charset");
                        if (charset != null) {
                            channel.setFilenameEncoding(charset);
                        }
                        this.channels.put(key, channel);
                        ResourceContext.get().getVisitedURIs().remove(new ResourceKey(new ResourceURI(uri.getURI())));
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ConfigException(e);
                    }
                    Object var8_9 = null;
                    ResourceContext.get().setCurrentURI(null);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    ResourceContext.get().setCurrentURI(null);
                    throw throwable;
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.channels;
        synchronized (map) {
            Iterator i = this.channels.values().iterator();
            while (i.hasNext()) {
                ChannelSftp channel = (ChannelSftp)i.next();
                i.remove();
                if (channel == null) continue;
                channel.quit();
                try {
                    channel.getSession().disconnect();
                }
                catch (JSchException e) {}
            }
        }
    }
}

