/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.util;

import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.util.IndexPageParser;
import com.alibaba.antx.config.resource.util.TextBasedPageParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Node;

public class SvnIndexPageParser
extends TextBasedPageParser {
    public List parse(Resource resource) {
        Node title;
        boolean xml = true;
        Document doc = this.getXmlDocument(resource);
        if (doc == null) {
            doc = this.getHtmlDocument(resource);
            xml = false;
        }
        ArrayList<IndexPageParser.Item> items = null;
        if (doc != null && xml) {
            DocumentType docType = doc.getDocType();
            if (docType != null && "svn".equalsIgnoreCase(docType.getName())) {
                items = new ArrayList<IndexPageParser.Item>();
                this.addNodes(items, doc.selectNodes("//dir/@name"), true);
                this.addNodes(items, doc.selectNodes("//file/@name"), false);
            }
        } else if (doc != null && !xml && (title = doc.selectSingleNode("//head/title")) != null && title.getText() != null && title.getText().indexOf("Revision") > 0) {
            List nodes = doc.selectNodes("//ul/li/a/@href");
            items = new ArrayList();
            for (Node node : nodes) {
                IndexPageParser.Item item;
                String name = node.getText();
                try {
                    name = URLDecoder.decode(name, this.getCharset(resource));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                if ((item = this.getItem(name)) == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    private void addNodes(List items, List listOfNodes, boolean directory) {
        for (Node node : listOfNodes) {
            items.add(new IndexPageParser.Item(node.getText(), directory));
        }
    }
}

