/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.config.resource.util;

import com.alibaba.antx.config.resource.Resource;
import com.alibaba.antx.config.resource.util.IndexPageParser;
import com.alibaba.antx.util.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.w3c.tidy.Tidy;

public abstract class TextBasedPageParser
implements IndexPageParser {
    private String overridingCharset;

    public TextBasedPageParser() {
    }

    public TextBasedPageParser(String overridingCharset) {
        this.setOverridingCharset(overridingCharset);
    }

    public void setOverridingCharset(String charset) {
        this.overridingCharset = charset;
    }

    protected Document getXmlDocument(Resource resource) {
        String contentType = resource.getContentType();
        if (contentType != null && contentType.startsWith("text/xml")) {
            try {
                return new SAXReader().read(resource.getInputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Document getHtmlDocument(Resource resource) {
        String contentType = resource.getContentType();
        if (contentType != null && contentType.startsWith("text/html")) {
            try {
                Tidy tidy = new Tidy();
                tidy.setQuiet(true);
                tidy.setXmlOut(true);
                tidy.setErrout(new PrintWriter(new ByteArrayOutputStream()));
                org.w3c.dom.Document dom = tidy.parseDOM(resource.getInputStream(), null);
                return new DOMReader().read(dom);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getCharset(Resource resource) {
        if (this.overridingCharset != null) {
            return this.overridingCharset;
        }
        if (resource.getCharset() != null) {
            return resource.getCharset();
        }
        return "ISO-8859-1";
    }

    protected IndexPageParser.Item getItem(String name) {
        if (name == null) {
            return null;
        }
        boolean directory = name.endsWith("/");
        if (directory) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.length() == 0 || name.indexOf("/") >= 0 || name.startsWith("?") || name.equals(".") || name.equals("..")) {
            return null;
        }
        return new IndexPageParser.Item(name, directory);
    }
}

