/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.antx.util;

import com.alibaba.antx.util.FileUtil;
import com.alibaba.antx.util.SelectorUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipScanner {
    protected URL zipURL;
    protected String[] includes;
    protected String[] excludes;
    protected List filesIncluded;
    protected List filesNotIncluded;
    protected List filesExcluded;
    protected List dirsIncluded;
    protected List dirsNotIncluded;
    protected List dirsExcluded;
    protected boolean isCaseSensitive = true;
    protected boolean everythingIncluded = true;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtil.matchPatternStart(pattern, str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtil.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtil.matchPath(pattern, str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtil.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtil.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtil.match(pattern, str, isCaseSensitive);
    }

    public void setZipURL(String zipURL) throws MalformedURLException {
        this.setSrc(new URL(zipURL));
    }

    public void setSrc(URL zipURL) {
        this.zipURL = zipURL;
    }

    public URL getZipURL() {
        return this.zipURL;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern = includes[i].replace('\\', '/');
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.includes[i] = pattern;
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                String pattern = excludes[i].replace('\\', '/');
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "**";
                }
                this.excludes[i] = pattern;
            }
        }
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    public void scan() throws IllegalStateException, IOException {
        if (this.zipURL == null) {
            throw new IllegalStateException("No zipURL set");
        }
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        this.filesIncluded = new ArrayList();
        this.filesNotIncluded = new ArrayList();
        this.filesExcluded = new ArrayList();
        this.dirsIncluded = new ArrayList();
        this.dirsNotIncluded = new ArrayList();
        this.dirsExcluded = new ArrayList();
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                this.dirsIncluded.add("");
            } else {
                this.dirsExcluded.add("");
            }
        } else {
            this.dirsNotIncluded.add("");
        }
        this.scanZipFile(this.zipURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanZipFile(URL zipURL) throws IOException {
        InputStream istream = null;
        ZipInputStream zipStream = null;
        try {
            ZipEntry entry;
            istream = zipURL.openStream();
            if (!(istream instanceof BufferedInputStream)) {
                istream = new BufferedInputStream(istream, 8192);
            }
            zipStream = new ZipInputStream(istream);
            while ((entry = zipStream.getNextEntry()) != null) {
                String name = entry.getName().replace('\\', '/');
                if (name.endsWith(File.separator)) {
                    name = name.substring(0, name.length() - 1);
                }
                if (entry.isDirectory()) {
                    if (this.isIncluded(name)) {
                        if (!this.isExcluded(name)) {
                            this.dirsIncluded.add(name);
                            continue;
                        }
                        this.everythingIncluded = false;
                        this.dirsExcluded.add(name);
                        continue;
                    }
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.add(name);
                    continue;
                }
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        this.filesIncluded.add(name);
                        continue;
                    }
                    this.everythingIncluded = false;
                    this.filesExcluded.add(name);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesNotIncluded.add(name);
            }
        }
        finally {
            if (zipStream != null) {
                try {
                    zipStream.close();
                }
                catch (IOException e) {}
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected boolean isIncluded(String name) {
        for (String include : this.includes) {
            if (!ZipScanner.matchPath(include, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (String exclude : this.excludes) {
            if (!ZipScanner.matchPath(exclude, name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public String[] getIncludedFiles() {
        return this.filesIncluded.toArray(new String[this.filesIncluded.size()]);
    }

    public String[] getNotIncludedFiles() {
        return this.filesNotIncluded.toArray(new String[this.filesNotIncluded.size()]);
    }

    public String[] getExcludedFiles() {
        return this.filesExcluded.toArray(new String[this.filesExcluded.size()]);
    }

    public String[] getIncludedDirectories() {
        return this.dirsIncluded.toArray(new String[this.dirsIncluded.size()]);
    }

    public String[] getNotIncludedDirectories() {
        return this.dirsNotIncluded.toArray(new String[this.dirsNotIncluded.size()]);
    }

    public String[] getExcludedDirectories() {
        return this.dirsExcluded.toArray(new String[this.dirsExcluded.size()]);
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + FileUtil.DEFAULT_EXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < FileUtil.DEFAULT_EXCLUDES.length; ++i) {
            newExcludes[i + excludesLength] = FileUtil.DEFAULT_EXCLUDES[i].replace('\\', '/');
        }
        this.excludes = newExcludes;
    }
}

